/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.FloatPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;

public interface FloatSupplier {
    public float getAsFloat();

    default public FloatSupplier filterNonFinite(float val) {
        return () -> {
            float value = this.getAsFloat();
            if (!Float.isFinite(value)) {
                value = val;
            }
            return value;
        };
    }

    default public FloatSupplier filterNaN(float val) {
        return () -> {
            float value = this.getAsFloat();
            if (Float.isNaN(value)) {
                value = val;
            }
            return value;
        };
    }

    default public DoubleSupplier toDoubleSupplier() {
        return this::getAsFloat;
    }

    public static FloatSupplier fromDoubleSupplier(DoubleSupplier supp) {
        return () -> (float)supp.getAsDouble();
    }

    default public BooleanSupplier toBooleanSupplier(FloatPredicate pred) {
        return () -> pred.test(this.getAsFloat());
    }
}

