/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.BooleanConsumer;
import com.mastfrog.function.state.BoolAtomic;
import com.mastfrog.function.state.BoolImpl;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface Bool
extends BooleanConsumer,
BooleanSupplier,
Supplier<Boolean>,
Consumer<Boolean> {
    public static Bool create() {
        return Bool.create(false);
    }

    public static Bool create(boolean val) {
        return new BoolImpl(val);
    }

    public static Bool createAtomic() {
        return new BoolAtomic();
    }

    public static Bool createAtomic(boolean val) {
        return new BoolAtomic(val);
    }

    default public boolean or(boolean val) {
        boolean old = this.getAsBoolean();
        this.set(old || val);
        return old != val;
    }

    default public boolean and(boolean val) {
        boolean newVal;
        boolean old = this.getAsBoolean();
        boolean bl = newVal = old && val;
        if (newVal != old) {
            this.set(newVal);
            return true;
        }
        return false;
    }

    default public boolean xor(boolean val) {
        boolean old = this.getAsBoolean();
        boolean nue = old ^ val;
        if (nue != old) {
            this.set(nue);
            return true;
        }
        return false;
    }

    default public BooleanSupplier or(BooleanSupplier other) {
        return () -> this.getAsBoolean() || other.getAsBoolean();
    }

    default public BooleanSupplier and(BooleanSupplier other) {
        return () -> this.getAsBoolean() && other.getAsBoolean();
    }

    default public BooleanSupplier xor(BooleanSupplier other) {
        return () -> this.getAsBoolean() ^ other.getAsBoolean();
    }

    default public boolean set() {
        return this.set(true);
    }

    default public boolean reset() {
        return this.set(false);
    }

    default public boolean runAndSet(Runnable r) {
        if (!this.getAsBoolean()) {
            r.run();
            this.set();
            return true;
        }
        return false;
    }

    default public boolean ifTrue(Runnable r) {
        if (this.getAsBoolean()) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifUntrue(Runnable r) {
        if (!this.getAsBoolean()) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean set(boolean val) {
        boolean old = this.get();
        if (old != val) {
            this.accept(val);
        }
        return old;
    }

    default public boolean toggle() {
        return this.set(!this.getAsBoolean());
    }

    @Override
    default public Boolean get() {
        return this.getAsBoolean();
    }

    @Override
    default public void accept(Boolean t) {
        this.accept((boolean)t);
    }
}

