/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Bool;
import java.util.concurrent.atomic.AtomicBoolean;

final class BoolAtomic
implements Bool {
    private final AtomicBoolean value;

    BoolAtomic(boolean value) {
        this.value = new AtomicBoolean(value);
    }

    BoolAtomic() {
        this.value = new AtomicBoolean();
    }

    @Override
    public boolean set() {
        return this.value.compareAndSet(false, true);
    }

    @Override
    public boolean reset() {
        return !this.value.getAndSet(false);
    }

    @Override
    public boolean runAndSet(Runnable r) {
        if (this.value.compareAndSet(false, true)) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public boolean set(boolean val) {
        boolean result = this.value.compareAndSet(!val, val);
        return result ? !val : val;
    }

    @Override
    public boolean toggle() {
        boolean old = this.value.get();
        this.value.set(!old);
        return old;
    }

    @Override
    public void accept(boolean val) {
        this.value.set(val);
    }

    @Override
    public boolean getAsBoolean() {
        return this.value.get();
    }
}

