/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.DblAtomic;
import com.mastfrog.function.state.DblImpl;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;

public interface Dbl
extends DoubleConsumer,
DoubleSupplier,
Consumer<Double>,
Supplier<Double> {
    public static Dbl create() {
        return new DblImpl();
    }

    public static Dbl of(double val) {
        return new DblImpl(val);
    }

    public static Dbl createAtomic() {
        return new DblAtomic();
    }

    public static Dbl ofAtomic(double val) {
        return new DblAtomic(val);
    }

    default public double apply(DoubleUnaryOperator op) {
        return this.set(op.applyAsDouble(this.getAsDouble()));
    }

    default public double apply(double val, DoubleBinaryOperator op) {
        return this.set(op.applyAsDouble(this.getAsDouble(), val));
    }

    default public boolean ifUpdate(double newVal, Runnable r) {
        boolean result;
        double oldVal = this.set(newVal);
        boolean bl = result = oldVal != newVal;
        if (result) {
            r.run();
        }
        return result;
    }

    @Override
    default public Double get() {
        return this.getAsDouble();
    }

    default public double set(double val) {
        double old = this.getAsDouble();
        this.accept(val);
        return old;
    }

    @Override
    default public void accept(Double t) {
        this.accept((double)t);
    }

    default public double add(double val) {
        double old = this.getAsDouble();
        this.accept(val + old);
        return old;
    }

    default public double subtract(double val) {
        return this.add(-val);
    }

    default public double max(double val) {
        double old = this.getAsDouble();
        if (val > old) {
            this.accept(val);
        }
        return old;
    }

    default public double min(double val) {
        double old = this.getAsDouble();
        if (val < old) {
            this.accept(val);
        }
        return old;
    }

    default public double reset() {
        return this.set(0.0);
    }

    default public DoubleConsumer summer() {
        return this::add;
    }

    default public double floor() {
        return Math.floor(this.getAsDouble());
    }

    default public double ceil() {
        return Math.ceil(this.getAsDouble());
    }

    default public double round() {
        return Math.round(this.getAsDouble());
    }

    default public DoubleSupplier combinedWith(DoubleSupplier otherValue, DoubleBinaryOperator formula) {
        return () -> formula.applyAsDouble(this.getAsDouble(), otherValue.getAsDouble());
    }
}

