/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Dbl;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;

final class DblAtomic
implements Dbl {
    private final AtomicLong value;

    DblAtomic(double val) {
        this.value = new AtomicLong(Double.doubleToLongBits(val));
    }

    DblAtomic() {
        this.value = new AtomicLong();
    }

    @Override
    public void accept(double value) {
        this.value.set(Double.doubleToLongBits(value));
    }

    @Override
    public double getAsDouble() {
        return Double.doubleToLongBits(this.value.get());
    }

    @Override
    public double apply(DoubleUnaryOperator op) {
        long lng = this.value.getAndUpdate(longOld -> Double.doubleToLongBits(op.applyAsDouble(Double.longBitsToDouble(longOld))));
        return Double.longBitsToDouble(lng);
    }

    @Override
    public double apply(double val, DoubleBinaryOperator op) {
        long lng = this.value.getAndAccumulate(Double.doubleToLongBits(val), (la, lb) -> Double.doubleToLongBits(op.applyAsDouble(Double.longBitsToDouble(la), Double.longBitsToDouble(lb))));
        return Double.longBitsToDouble(lng);
    }

    @Override
    public double set(double val) {
        return Double.longBitsToDouble(this.value.getAndSet(Double.doubleToLongBits(val)));
    }

    @Override
    public double add(double val) {
        return Double.longBitsToDouble(this.value.getAndAccumulate(Double.doubleToLongBits(val), (la, lb) -> {
            double a = Double.longBitsToDouble(la);
            double b = Double.longBitsToDouble(lb);
            return Double.doubleToLongBits(a + b);
        }));
    }

    @Override
    public double min(double val) {
        return Double.longBitsToDouble(this.value.getAndAccumulate(Double.doubleToLongBits(val), (la, lb) -> {
            double a = Double.longBitsToDouble(la);
            double b = Double.longBitsToDouble(lb);
            return Double.doubleToLongBits(Math.min(a, b));
        }));
    }

    @Override
    public double max(double val) {
        return Double.longBitsToDouble(this.value.getAndAccumulate(Double.doubleToLongBits(val), (la, lb) -> {
            double a = Double.longBitsToDouble(la);
            double b = Double.longBitsToDouble(lb);
            return Double.doubleToLongBits(Math.max(a, b));
        }));
    }

    @Override
    public boolean ifUpdate(double newVal, Runnable r) {
        long lv = Double.doubleToLongBits(newVal);
        long oldValue = this.value.getAndAccumulate(lv, (la, lb) -> la);
        if (oldValue != lv) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public double subtract(double val) {
        return this.add(-val);
    }

    @Override
    public DoubleConsumer summer() {
        return this::add;
    }

    public String toString() {
        return Double.toString(this.getAsDouble());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DblAtomic) {
            DblAtomic db = (DblAtomic)o;
            return db.value.get() == this.value.get();
        }
        if (o instanceof Dbl) {
            long b;
            double otherVal = ((Dbl)o).getAsDouble();
            long a = this.value.get();
            return a == (b = Double.doubleToLongBits(otherVal + 0.0));
        }
        return false;
    }

    public int hashCode() {
        long val = this.value.get();
        return (int)(val ^ val >> 32);
    }
}

