/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.FloatConsumer;
import com.mastfrog.function.FloatSupplier;
import com.mastfrog.function.state.FloatBinaryOperator;
import com.mastfrog.function.state.FloatUnaryOperator;
import com.mastfrog.function.state.FltAtomic;
import com.mastfrog.function.state.FltImpl;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface Flt
extends FloatConsumer,
FloatSupplier,
Consumer<Float>,
Supplier<Float> {
    public static Flt create() {
        return new FltImpl();
    }

    public static Flt of(float val) {
        return new FltImpl(val);
    }

    public static Flt createAtomic() {
        return new FltAtomic();
    }

    public static Flt ofAtomic(float val) {
        return new FltAtomic(val);
    }

    default public float apply(FloatUnaryOperator op) {
        return this.set(op.applyAsFloat(this.getAsFloat()));
    }

    default public float apply(float val, FloatBinaryOperator op) {
        return this.set(op.applyAsFloat(this.getAsFloat(), val));
    }

    @Override
    default public Float get() {
        return Float.valueOf(this.getAsFloat());
    }

    default public float set(float val) {
        float old = this.getAsFloat();
        this.accept(val);
        return old;
    }

    @Override
    default public void accept(Float t) {
        this.accept(t.floatValue());
    }

    default public float add(float val) {
        float old = this.getAsFloat();
        this.accept(val + old);
        return old;
    }

    default public float subtract(float val) {
        return this.add(-val);
    }

    default public float max(float val) {
        float old = this.getAsFloat();
        if (val > old) {
            this.accept(val);
        }
        return old;
    }

    default public float min(float val) {
        float old = this.getAsFloat();
        if (val < old) {
            this.accept(val);
        }
        return old;
    }

    default public float reset() {
        return this.set(0.0f);
    }

    default public FloatConsumer summer() {
        return this::add;
    }

    default public float floor() {
        return (float)Math.floor(this.getAsFloat());
    }

    default public float ceil() {
        return (float)Math.ceil(this.getAsFloat());
    }

    default public int round() {
        return Math.round(this.getAsFloat());
    }

    default public FloatSupplier combinedWith(FloatSupplier otherValue, FloatBinaryOperator formula) {
        return () -> formula.applyAsFloat(this.getAsFloat(), otherValue.getAsFloat());
    }
}

