/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.FloatConsumer;
import com.mastfrog.function.state.FloatBinaryOperator;
import com.mastfrog.function.state.FloatUnaryOperator;
import com.mastfrog.function.state.Flt;
import java.util.concurrent.atomic.AtomicInteger;

final class FltAtomic
implements Flt {
    private final AtomicInteger value;

    FltAtomic(float val) {
        this.value = new AtomicInteger(Float.floatToIntBits(val));
    }

    FltAtomic() {
        this.value = new AtomicInteger();
    }

    @Override
    public void accept(float value) {
        this.value.set(Float.floatToIntBits(value));
    }

    @Override
    public float getAsFloat() {
        return Float.floatToIntBits(this.value.get());
    }

    @Override
    public float apply(FloatUnaryOperator op) {
        int result = this.value.getAndUpdate(longOld -> Float.floatToIntBits(op.applyAsFloat(Float.intBitsToFloat(longOld))));
        return Float.intBitsToFloat(result);
    }

    @Override
    public float apply(float val, FloatBinaryOperator op) {
        int lng = this.value.getAndAccumulate(Float.floatToIntBits(val), (la, lb) -> Float.floatToIntBits(op.applyAsFloat(Float.intBitsToFloat(la), Float.intBitsToFloat(lb))));
        return Float.intBitsToFloat(lng);
    }

    @Override
    public float set(float val) {
        return Float.intBitsToFloat(this.value.getAndSet(Float.floatToIntBits(val)));
    }

    @Override
    public float add(float val) {
        return Float.intBitsToFloat(this.value.getAndAccumulate(Float.floatToIntBits(val), (la, lb) -> {
            float a = Float.intBitsToFloat(la);
            float b = Float.intBitsToFloat(lb);
            return Float.floatToIntBits(a + b);
        }));
    }

    @Override
    public float min(float val) {
        return Float.intBitsToFloat(this.value.getAndAccumulate(Float.floatToIntBits(val), (la, lb) -> {
            float a = Float.intBitsToFloat(la);
            float b = Float.intBitsToFloat(lb);
            return Float.floatToIntBits(Math.min(a, b));
        }));
    }

    @Override
    public float max(float val) {
        return Float.intBitsToFloat(this.value.getAndAccumulate(Float.floatToIntBits(val), (la, lb) -> {
            float a = Float.intBitsToFloat(la);
            float b = Float.intBitsToFloat(lb);
            return Float.floatToIntBits(Math.max(a, b));
        }));
    }

    @Override
    public float subtract(float val) {
        return this.add(-val);
    }

    @Override
    public FloatConsumer summer() {
        return this::add;
    }

    public String toString() {
        return Float.toString(this.getAsFloat());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof FltAtomic) {
            FltAtomic db = (FltAtomic)o;
            return db.value.get() == this.value.get();
        }
        if (o instanceof Flt) {
            long b;
            float otherVal = ((Flt)o).getAsFloat();
            long a = this.value.get();
            return a == (b = (long)Float.floatToIntBits(otherVal + 0.0f));
        }
        return false;
    }

    public int hashCode() {
        long val = this.value.get();
        return (int)(val ^ val >> 32);
    }
}

