/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.FloatSupplier;
import com.mastfrog.function.state.IntAtomic;
import com.mastfrog.function.state.IntImpl;
import com.mastfrog.function.state.IntWithChildren;
import com.mastfrog.function.state.IntWithChildrenImpl;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface Int
extends IntConsumer,
IntSupplier,
Supplier<Integer>,
Comparable<Int>,
Consumer<Integer> {
    public static Int of(int initial) {
        return new IntImpl(initial);
    }

    public static Int create() {
        return new IntImpl();
    }

    public static Int of(AtomicInteger at) {
        return new IntAtomic(at);
    }

    public static Int ofAtomic(int initial) {
        return new IntAtomic(initial);
    }

    public static Int createAtomic() {
        return new IntAtomic();
    }

    public static IntWithChildren createWithChildren() {
        return new IntWithChildrenImpl();
    }

    public static IntWithChildren ofWithChildren(int initial) {
        return new IntWithChildrenImpl(initial);
    }

    default public int apply(IntUnaryOperator op) {
        return this.set(op.applyAsInt(this.getAsInt()));
    }

    default public int apply(int val, IntBinaryOperator op) {
        return this.set(op.applyAsInt(this.getAsInt(), val));
    }

    default public int getLess(int amt) {
        return this.getAsInt() - amt;
    }

    default public boolean ifUpdate(int newVal, Runnable r) {
        boolean result;
        int oldVal = this.set(newVal);
        boolean bl = result = oldVal != newVal;
        if (result) {
            r.run();
        }
        return result;
    }

    default public int decrement() {
        return this.decrement(1);
    }

    default public int decrement(int by) {
        return this.increment(-by);
    }

    default public int decrementSafe(int by) {
        return this.set(Math.subtractExact(this.getAsInt(), by));
    }

    default public int decrementSafe() {
        return this.decrementSafe(1);
    }

    @Override
    default public Integer get() {
        return this.getAsInt();
    }

    @Override
    default public void accept(int value) {
        this.set(value);
    }

    @Override
    default public void accept(Integer value) {
        this.set(value);
    }

    default public boolean ifNotEqual(int value, Runnable r) {
        if (this.getAsInt() != value) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifEqual(int value, Runnable r) {
        if (this.getAsInt() == value) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifGreater(int than, Runnable r) {
        if (this.getAsInt() > than) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifLess(int than, Runnable r) {
        if (this.getAsInt() < than) {
            r.run();
            return true;
        }
        return false;
    }

    default public int incrementSafe() {
        return this.incrementSafe(1);
    }

    default public int incrementSafe(int by) {
        return this.set(Math.addExact(this.getAsInt(), by));
    }

    default public int increment() {
        return this.increment(1);
    }

    default public int increment(int by) {
        return this.set(this.getAsInt() + by);
    }

    default public Int reset() {
        this.set(0);
        return this;
    }

    public int set(int var1);

    default public int min(int min) {
        int val = this.getAsInt();
        if (min < val) {
            this.set(min);
        }
        return val;
    }

    default public int max(int max) {
        int val = this.getAsInt();
        if (max > val) {
            this.set(max);
        }
        return val;
    }

    default public IntConsumer summer() {
        return this::increment;
    }

    @Override
    default public int compareTo(Int o) {
        return Integer.compare(this.getAsInt(), o.getAsInt());
    }

    default public BooleanSupplier toBooleanSupplier(IntPredicate pred) {
        return () -> pred.test(this.getAsInt());
    }

    default public boolean equals(int val) {
        return val == this.getAsInt();
    }

    default public int setFrom(IntSupplier supp) {
        return this.set(supp.getAsInt());
    }

    default public LongSupplier plus(IntSupplier supp) {
        return () -> (long)this.getAsInt() + (long)supp.getAsInt();
    }

    default public IntSupplier plusSafe(IntSupplier supp) {
        return () -> Math.addExact(this.getAsInt(), supp.getAsInt());
    }

    default public IntSupplier minusSafe(IntSupplier supp) {
        return () -> Math.subtractExact(this.getAsInt(), supp.getAsInt());
    }

    default public IntSupplier timesSafe(IntSupplier supp) {
        return () -> Math.multiplyExact(this.getAsInt(), supp.getAsInt());
    }

    default public LongSupplier minus(IntSupplier supp) {
        return this.plus(() -> -supp.getAsInt());
    }

    default public LongSupplier times(IntSupplier supp) {
        return () -> (long)this.getAsInt() * (long)supp.getAsInt();
    }

    default public IntSupplier dividedBy(IntSupplier supp) {
        return () -> {
            int suppVal = supp.getAsInt();
            return suppVal == 0 ? 0 : this.getAsInt() / suppVal;
        };
    }

    default public FloatSupplier asFloatSupplier() {
        return () -> this.getAsInt();
    }

    default public DoubleSupplier asDoubleSupplier() {
        return () -> this.getAsInt();
    }

    default public LongSupplier asLongSupplier() {
        return () -> this.getAsInt();
    }

    default public long unsignedValue() {
        return (long)this.getAsInt() & 0xFFFFFFFFL;
    }

    default public IntSupplier combinedWith(IntSupplier otherValue, IntBinaryOperator formula) {
        return () -> formula.applyAsInt(this.getAsInt(), otherValue.getAsInt());
    }
}

