/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Int;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;

final class IntAtomic
implements Int {
    private final AtomicInteger value;

    IntAtomic(AtomicInteger value) {
        this.value = value;
    }

    IntAtomic() {
        this(new AtomicInteger());
    }

    IntAtomic(int val) {
        this(new AtomicInteger(val));
    }

    @Override
    public int apply(IntUnaryOperator op) {
        return this.value.getAndUpdate(op);
    }

    @Override
    public int apply(int val, IntBinaryOperator op) {
        return this.value.getAndAccumulate(val, op);
    }

    @Override
    public boolean ifUpdate(int newVal, Runnable r) {
        if (this.value.getAndSet(newVal) != newVal) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public int decrement(int val) {
        return this.value.addAndGet(-val);
    }

    @Override
    public Integer get() {
        return this.value.get();
    }

    @Override
    public void accept(int value) {
        this.value.set(value);
    }

    @Override
    public void accept(Integer value) {
        this.value.set(value);
    }

    @Override
    public boolean ifNotEqual(int value, Runnable r) {
        if (this.getAsInt() != value) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public int increment() {
        return this.value.getAndIncrement();
    }

    @Override
    public int increment(int val) {
        return this.value.getAndAdd(val);
    }

    @Override
    public Int reset() {
        this.value.set(0);
        return this;
    }

    @Override
    public int set(int val) {
        return this.value.getAndSet(val);
    }

    @Override
    public int min(int min) {
        return this.value.getAndAccumulate(min, (a, b) -> Math.min(a, b));
    }

    @Override
    public int max(int max) {
        return this.value.getAndAccumulate(max, (a, b) -> Math.max(a, b));
    }

    @Override
    public IntConsumer summer() {
        return this.value::getAndAdd;
    }

    @Override
    public boolean equals(int val) {
        return this.value.get() == val;
    }

    @Override
    public int getAsInt() {
        return this.value.get();
    }
}

