/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.FloatSupplier;
import com.mastfrog.function.state.LngAtomic;
import com.mastfrog.function.state.LngImpl;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;

public interface Lng
extends LongConsumer,
LongSupplier,
Supplier<Long>,
Comparable<Lng>,
Consumer<Long> {
    public static Lng of(long initial) {
        return new LngImpl(initial);
    }

    public static Lng create() {
        return new LngImpl();
    }

    public static Lng ofAtomic(long initial) {
        return new LngAtomic(initial);
    }

    public static Lng createAtomic() {
        return new LngAtomic();
    }

    default public long apply(LongUnaryOperator op) {
        return this.set(op.applyAsLong(this.getAsLong()));
    }

    default public long apply(long val, LongBinaryOperator op) {
        return this.set(op.applyAsLong(this.getAsLong(), val));
    }

    default public long getLess(long amt) {
        return this.getAsLong() - amt;
    }

    default public boolean ifUpdate(long newVal, Runnable r) {
        boolean result;
        long oldVal = this.set(newVal);
        boolean bl = result = oldVal != newVal;
        if (result) {
            r.run();
        }
        return result;
    }

    default public long decrement() {
        return this.decrement(1L);
    }

    default public long decrement(long val) {
        return this.increment(-val);
    }

    default public long decrementSafe(long by) {
        long val = this.getAsLong();
        return this.set(Math.subtractExact(val, by));
    }

    @Override
    default public Long get() {
        return this.getAsLong();
    }

    @Override
    default public void accept(long value) {
        this.set(value);
    }

    @Override
    default public void accept(Long value) {
        this.set(value);
    }

    default public boolean ifNotEqual(long value, Runnable r) {
        if (this.getAsLong() != value) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifEqual(long value, Runnable r) {
        if (this.getAsLong() == value) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifGreater(long than, Runnable r) {
        if (this.getAsLong() > than) {
            r.run();
            return true;
        }
        return false;
    }

    default public boolean ifLess(long than, Runnable r) {
        if (this.getAsLong() < than) {
            r.run();
            return true;
        }
        return false;
    }

    default public long increment() {
        return this.increment(1L);
    }

    default public long increment(long val) {
        return this.set(this.getAsLong() + val);
    }

    default public long incrementSafe(long by) {
        return this.set(Math.addExact(this.getAsLong(), by));
    }

    default public Lng reset() {
        this.set(0L);
        return this;
    }

    public long set(long var1);

    default public long min(long min) {
        long val = this.getAsLong();
        if (min < val) {
            this.set(min);
        }
        return val;
    }

    default public long max(long max) {
        long val = this.getAsLong();
        if (max > val) {
            this.set(max);
        }
        return val;
    }

    default public LongConsumer summer() {
        return this::increment;
    }

    @Override
    default public int compareTo(Lng o) {
        return Long.compare(this.getAsLong(), o.getAsLong());
    }

    default public BooleanSupplier toBooleanSupplier(LongPredicate pred) {
        return () -> pred.test(this.getAsLong());
    }

    default public boolean equals(long val) {
        return val == this.getAsLong();
    }

    default public LongSupplier plus(LongSupplier supp) {
        return () -> this.getAsLong() + supp.getAsLong();
    }

    default public LongSupplier minus(LongSupplier supp) {
        return () -> this.getAsLong() - supp.getAsLong();
    }

    default public LongSupplier times(LongSupplier supp) {
        return () -> this.getAsLong() * supp.getAsLong();
    }

    default public LongSupplier dividedBy(LongSupplier supp) {
        return () -> {
            long suppVal = supp.getAsLong();
            return suppVal == 0L ? 0L : this.getAsLong() / supp.getAsLong();
        };
    }

    default public FloatSupplier asFloatSupplier() {
        return () -> this.getAsLong();
    }

    default public DoubleSupplier asDoubleSupplier() {
        return () -> this.getAsLong();
    }

    default public LongSupplier asLongSupplier() {
        return () -> this.getAsLong();
    }

    default public LongSupplier combinedWith(LongSupplier otherValue, LongBinaryOperator formula) {
        return () -> formula.applyAsLong(this.getAsLong(), otherValue.getAsLong());
    }
}

