/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Lng;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongUnaryOperator;

final class LngAtomic
implements Lng {
    private final AtomicLong value;

    LngAtomic(AtomicLong value) {
        this.value = value;
    }

    LngAtomic() {
        this(new AtomicLong());
    }

    LngAtomic(long val) {
        this(new AtomicLong(val));
    }

    @Override
    public long apply(LongUnaryOperator op) {
        return this.value.getAndUpdate(op);
    }

    @Override
    public long apply(long val, LongBinaryOperator op) {
        return this.value.getAndAccumulate(val, op);
    }

    @Override
    public boolean ifUpdate(long newVal, Runnable r) {
        if (this.value.getAndSet(newVal) != newVal) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public long decrement(long val) {
        return this.value.addAndGet(-val);
    }

    @Override
    public Long get() {
        return this.value.get();
    }

    @Override
    public void accept(long value) {
        this.value.set(value);
    }

    @Override
    public void accept(Long value) {
        this.value.set(value);
    }

    @Override
    public boolean ifNotEqual(long value, Runnable r) {
        if (this.getAsLong() != value) {
            r.run();
            return true;
        }
        return false;
    }

    @Override
    public long increment() {
        return this.value.getAndIncrement();
    }

    @Override
    public long increment(long val) {
        return this.value.getAndAdd(val);
    }

    @Override
    public Lng reset() {
        this.value.set(0L);
        return this;
    }

    @Override
    public long set(long val) {
        return this.value.getAndSet(val);
    }

    @Override
    public long min(long min) {
        return this.value.getAndAccumulate(min, (a, b) -> Math.min(a, b));
    }

    @Override
    public long max(long max) {
        return this.value.getAndAccumulate(max, (a, b) -> Math.max(a, b));
    }

    @Override
    public LongConsumer summer() {
        return this.value::getAndAdd;
    }

    @Override
    public boolean equals(long val) {
        return this.value.get() == val;
    }

    @Override
    public long getAsLong() {
        return this.value.get();
    }
}

