/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.ObjAtomic;
import com.mastfrog.function.state.ObjImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface Obj<T>
extends Supplier<T>,
Consumer<T> {
    public T set(T var1);

    @Override
    default public void accept(T t) {
        this.set(t);
    }

    public static <T> Obj<T> create() {
        return new ObjImpl();
    }

    public static <T> Obj<T> of(T object) {
        return new ObjImpl<T>(object);
    }

    public static <T> Obj<T> createAtomic() {
        return new ObjAtomic();
    }

    public static <T> Obj<T> ofAtomic(AtomicReference<T> ref) {
        return new ObjAtomic<AtomicReference<T>>(ref);
    }

    public static <T> Obj<T> ofAtomic(T object) {
        return new ObjAtomic<T>(object);
    }

    default public boolean is(T obj) {
        return Objects.equals(obj, this.get());
    }

    default public boolean isSet() {
        return this.get() != null;
    }

    default public boolean isNull() {
        return this.get() == null;
    }

    public boolean ifUpdate(T var1, Runnable var2);

    default public boolean ifNullSet(Supplier<T> supp) {
        T obj;
        if (!this.isSet() && (obj = supp.get()) != null) {
            this.set(supp.get());
            return true;
        }
        return false;
    }

    default public T apply(UnaryOperator<T> op) {
        return (T)this.set(op.apply(this.get()));
    }

    default public T apply(T other, BinaryOperator<T> op) {
        return (T)this.set(op.apply(this.get(), other));
    }

    default public T setFrom(Supplier<T> supp) {
        return this.set(supp.get());
    }
}

