/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Bool;
import com.mastfrog.function.state.Obj;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

final class ObjAtomic<T>
implements Obj<T> {
    private final AtomicReference<T> value;

    ObjAtomic(AtomicReference<T> value) {
        this.value = value;
    }

    ObjAtomic(T initial) {
        this.value = initial == null ? new AtomicReference() : new AtomicReference<T>(initial);
    }

    ObjAtomic() {
        this.value = new AtomicReference();
    }

    @Override
    public T get() {
        return this.value.get();
    }

    @Override
    public T set(T obj) {
        return this.value.getAndSet(obj);
    }

    @Override
    public void accept(T t) {
        this.set(t);
    }

    @Override
    public boolean ifUpdate(T newValue, Runnable ifChange) {
        T old = this.value.getAndSet(newValue);
        if (!Objects.equals(old, newValue)) {
            ifChange.run();
            return true;
        }
        return false;
    }

    @Override
    public boolean ifNullSet(Supplier<T> supp) {
        Bool updated = Bool.createAtomic();
        this.value.getAndUpdate(old -> {
            if (old != null) {
                updated.set(false);
                return old;
            }
            updated.set(true);
            return supp.get();
        });
        return updated.get();
    }

    @Override
    public T apply(UnaryOperator<T> op) {
        return this.value.getAndUpdate(op);
    }

    @Override
    public T apply(T other, BinaryOperator<T> op) {
        return this.value.getAndAccumulate(other, op);
    }

    public int hashCode() {
        return Objects.hashCode(this.value.get());
    }

    public boolean equals(Object o) {
        return o == this ? true : o instanceof Obj && Objects.equals(this.value.get(), ((Obj)o).get());
    }

    public String toString() {
        return Objects.toString(this.get());
    }
}

