/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.state;

import com.mastfrog.function.state.Obj;
import java.util.Objects;

final class ObjImpl<T>
implements Obj<T> {
    private T obj;

    ObjImpl() {
    }

    ObjImpl(T initial) {
        this.obj = initial;
    }

    @Override
    public T get() {
        return this.obj;
    }

    @Override
    public T set(T obj) {
        T old = this.obj;
        this.obj = obj;
        return old;
    }

    @Override
    public boolean ifUpdate(T newValue, Runnable ifChange) {
        if (!Objects.equals(this.obj, newValue)) {
            this.obj = newValue;
            ifChange.run();
            return true;
        }
        return false;
    }

    public String toString() {
        return Objects.toString(this.obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.obj);
    }

    public boolean equals(Object o) {
        return o == this ? true : o instanceof Obj && Objects.equals(this.obj, ((Obj)o).get());
    }
}

