/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.io.IOBiConsumer;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface ThrowingBiConsumer<T, R> {
    public void accept(T var1, R var2) throws Exception;

    default public ThrowingBiConsumer<T, R> andThen(ThrowingBiConsumer<T, R> tb) {
        return (a, b) -> {
            this.accept(a, b);
            tb.accept(a, b);
        };
    }

    default public ThrowingBiConsumer<T, R> andThen(BiConsumer<T, R> tb) {
        return (a, b) -> {
            this.accept(a, b);
            tb.accept(a, b);
        };
    }

    default public ThrowingBiConsumer<T, R> andThen(IOBiConsumer<T, R> tb) {
        return (a, b) -> {
            this.accept(a, b);
            tb.accept(a, b);
        };
    }

    @Deprecated
    default public BiConsumer<T, R> asBiconsumer() {
        return this.toNonThrowing();
    }

    default public BiConsumer<T, R> toNonThrowing() {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Exception e) {
                Exceptions.chuck((Throwable)e);
            }
        };
    }
}

