/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.BiPredicate;

public interface ThrowingBiPredicate<A, B> {
    public boolean test(A var1, B var2) throws Exception;

    default public BiPredicate<A, B> toNonThrowing() {
        return (a, b) -> {
            try {
                return this.test(a, b);
            }
            catch (Exception ex) {
                return (Boolean)Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public ThrowingBiPredicate<A, B> and(ThrowingBiPredicate<? super A, ? super B> other) {
        return (a, b) -> this.test(a, b) && other.test(a, b);
    }

    default public ThrowingBiPredicate<A, B> or(ThrowingBiPredicate<? super A, ? super B> other) {
        return (a, b) -> this.test(a, b) || other.test(a, b);
    }

    default public ThrowingBiPredicate<A, B> andNot(ThrowingBiPredicate<? super A, ? super B> other) {
        return (a, b) -> this.test(a, b) && !other.test(a, b);
    }

    default public ThrowingBiPredicate<A, B> xor(ThrowingBiPredicate<? super A, ? super B> other) {
        return (a, b) -> this.test(a, b) != other.test(a, b);
    }
}

