/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface ThrowingBooleanSupplier {
    public boolean getAsBoolean() throws Exception;

    default public BooleanSupplier toNonThrowing() {
        return () -> {
            try {
                return this.getAsBoolean();
            }
            catch (Exception ex) {
                return (Boolean)Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public ThrowingBooleanSupplier invert() {
        return () -> !this.getAsBoolean();
    }

    default public ThrowingBooleanSupplier and(ThrowingBooleanSupplier other) {
        return () -> this.getAsBoolean() && other.getAsBoolean();
    }

    default public ThrowingBooleanSupplier andNot(ThrowingBooleanSupplier other) {
        return () -> this.getAsBoolean() && !other.getAsBoolean();
    }

    default public ThrowingBooleanSupplier or(ThrowingBooleanSupplier other) {
        return () -> this.getAsBoolean() || other.getAsBoolean();
    }

    default public ThrowingBooleanSupplier and(BooleanSupplier other) {
        return () -> this.getAsBoolean() && other.getAsBoolean();
    }

    default public ThrowingBooleanSupplier andNot(BooleanSupplier other) {
        return () -> this.getAsBoolean() && !other.getAsBoolean();
    }

    default public ThrowingBooleanSupplier or(BooleanSupplier other) {
        return () -> this.getAsBoolean() || other.getAsBoolean();
    }

    default public void ifTrue(ThrowingRunnable run) throws Exception {
        if (this.getAsBoolean()) {
            run.run();
        }
    }

    default public void ifFalse(ThrowingRunnable run) throws Exception {
        if (!this.getAsBoolean()) {
            run.run();
        }
    }
}

