/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<In, Out> {
    public Out apply(In var1) throws Exception;

    @Deprecated
    default public Function<In, Out> toFunction() {
        return this.toNonThrowing();
    }

    default public Function<In, Out> toNonThrowing() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception ex) {
                return Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public <V> ThrowingFunction<V, Out> compose(Function<? super V, ? extends In> before) {
        Checks.notNull((String)"before", before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> ThrowingFunction<In, V> andThen(Function<? super Out, ? extends V> after) {
        Checks.notNull((String)"after", after);
        Objects.requireNonNull(after);
        return t -> after.apply((Out)this.apply(t));
    }

    default public <NextOut> ThrowingFunction<In, NextOut> andThen(ThrowingFunction<Out, NextOut> f) {
        return in -> f.apply(this.apply(in));
    }
}

