/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.throwing.ThrowingShortBiConsumer;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.Objects;

@FunctionalInterface
public interface ThrowingIntBiConsumer {
    public void accept(int var1, int var2) throws Exception;

    default public ThrowingShortBiConsumer toShortBiConsumer() {
        return (a, b) -> this.accept(a, b);
    }

    default public IntBiConsumer toNonThrowing() {
        return (a, b) -> {
            try {
                this.accept(a, b);
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public ThrowingIntBiConsumer andThen(IntBiConsumer after) {
        Objects.requireNonNull(after);
        return (a, b) -> {
            this.accept(a, b);
            after.accept(a, b);
        };
    }

    default public ThrowingIntBiConsumer andThen(ThrowingIntBiConsumer after) {
        Objects.requireNonNull(after);
        return (a, b) -> {
            this.accept(a, b);
            after.accept(a, b);
        };
    }
}

