/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ThrowingShortConsumer;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.Objects;
import java.util.function.IntConsumer;

@FunctionalInterface
public interface ThrowingIntConsumer {
    public void accept(int var1) throws Exception;

    default public IntConsumer toNonThrowing() {
        return val -> {
            try {
                this.accept(val);
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public ThrowingShortConsumer toShortConsumer() {
        return val -> this.accept(val);
    }

    default public ThrowingIntConsumer andThen(IntConsumer after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public ThrowingIntConsumer andThen(ThrowingIntConsumer after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }
}

