/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;

@FunctionalInterface
public interface ThrowingLongSupplier {
    public long getAsLong() throws Exception;

    default public LongSupplier toNonThrowing() {
        return () -> {
            try {
                return this.getAsLong();
            }
            catch (Exception ex) {
                return (Long)Exceptions.chuck((Throwable)ex);
            }
        };
    }

    default public ThrowingLongSupplier or(LongPredicate test, LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return test.test(result) ? result : next.getAsLong();
        };
    }

    default public ThrowingLongSupplier ifZero(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? next.getAsLong() : result;
        };
    }

    default public ThrowingLongSupplier plus(LongSupplier next) {
        return () -> this.getAsLong() + next.getAsLong();
    }

    default public ThrowingLongSupplier times(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? 0L : result * next.getAsLong();
        };
    }

    default public ThrowingLongSupplier minus(LongSupplier next) {
        return () -> this.getAsLong() - next.getAsLong();
    }

    default public ThrowingLongSupplier mod(LongSupplier next) {
        return () -> this.getAsLong() % next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseOr(LongSupplier next) {
        return () -> this.getAsLong() | next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseXor(LongSupplier next) {
        return () -> this.getAsLong() ^ next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseAnd(LongSupplier next) {
        return () -> this.getAsLong() & next.getAsLong();
    }

    default public ThrowingLongSupplier dividedBy(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            long div = next.getAsLong();
            return result == 0L || div == 0L ? 0L : result / div;
        };
    }

    default public ThrowingLongSupplier or(LongPredicate test, ThrowingLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return test.test(result) ? result : next.getAsLong();
        };
    }

    default public ThrowingLongSupplier ifZero(ThrowingLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? next.getAsLong() : result;
        };
    }

    default public ThrowingLongSupplier plus(ThrowingLongSupplier next) {
        return () -> this.getAsLong() + next.getAsLong();
    }

    default public ThrowingLongSupplier times(ThrowingLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? 0L : result * next.getAsLong();
        };
    }

    default public ThrowingLongSupplier minus(ThrowingLongSupplier next) {
        return () -> this.getAsLong() - next.getAsLong();
    }

    default public ThrowingLongSupplier mod(ThrowingLongSupplier next) {
        return () -> this.getAsLong() % next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseOr(ThrowingLongSupplier next) {
        return () -> this.getAsLong() | next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseXor(ThrowingLongSupplier next) {
        return () -> this.getAsLong() ^ next.getAsLong();
    }

    default public ThrowingLongSupplier bitwiseAnd(ThrowingLongSupplier next) {
        return () -> this.getAsLong() & next.getAsLong();
    }

    default public ThrowingLongSupplier dividedBy(ThrowingLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            long div = next.getAsLong();
            return result == 0L || div == 0L ? 0L : result / div;
        };
    }

    default public ThrowingSupplier<Long> toBoxedSupplier() {
        return () -> this.getAsLong();
    }
}

