/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing;

import com.mastfrog.function.throwing.ComposableThrowingRunnable;
import com.mastfrog.function.throwing.NoOpThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingRunnable {
    public static final ThrowingRunnable NO_OP = new NoOpThrowingRunnable();

    public static ThrowingRunnable oneShot() {
        return new ComposableThrowingRunnable(true, false);
    }

    public static ThrowingRunnable composable() {
        return new ComposableThrowingRunnable(false, false);
    }

    public static ThrowingRunnable oneShot(boolean lifo) {
        return new ComposableThrowingRunnable(true, lifo);
    }

    public static ThrowingRunnable composable(boolean lifo) {
        return new ComposableThrowingRunnable(false, lifo);
    }

    public void run() throws Exception;

    default public Runnable toRunnable() {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                Exceptions.chuck((Throwable)e);
            }
        };
    }

    default public ThrowingRunnable andThen(ThrowingRunnable run) {
        return () -> {
            this.run();
            run.run();
        };
    }

    default public ThrowingRunnable andAlways(ThrowingRunnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                this.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                try {
                    run.run();
                }
                catch (Exception ex2) {
                    if (ex[0] == null) {
                        ex[0] = ex2;
                    }
                    ex[0].addSuppressed(ex2);
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public ThrowingRunnable andAlwaysFirst(ThrowingRunnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                run.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                try {
                    this.run();
                }
                catch (Exception ex2) {
                    if (ex[0] == null) {
                        ex[0] = ex2;
                    }
                    ex[0].addSuppressed(ex2);
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public <T> ThrowingRunnable of(ThrowingSupplier<T> supp, ThrowingConsumer<T> cons) {
        return () -> cons.accept(supp.get());
    }

    default public ThrowingRunnable of(Runnable r) {
        return r::run;
    }

    default public ThrowingRunnable andAlwaysRun(Runnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                this.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                try {
                    run.run();
                }
                catch (Exception ex2) {
                    if (ex[0] == null) {
                        ex[0] = ex2;
                    }
                    ex[0].addSuppressed(ex2);
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public ThrowingRunnable andAlwaysRunFirst(Runnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                run.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                try {
                    this.run();
                }
                catch (Exception ex2) {
                    if (ex[0] == null) {
                        ex[0] = ex2;
                    }
                    ex[0].addSuppressed(ex2);
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public ThrowingRunnable andAlwaysIf(BooleanSupplier test, ThrowingRunnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                this.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                if (test.getAsBoolean()) {
                    try {
                        run.run();
                    }
                    catch (Exception ex2) {
                        if (ex[0] == null) {
                            ex[0] = ex2;
                        }
                        ex[0].addSuppressed(ex2);
                    }
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public ThrowingRunnable andAlwaysIfNotNull(Supplier<?> testForNull, ThrowingRunnable run) {
        return () -> {
            Exception[] ex = new Exception[1];
            try {
                this.run();
            }
            catch (Exception ex1) {
                ex[0] = ex1;
            }
            finally {
                if (testForNull.get() != null) {
                    try {
                        run.run();
                    }
                    catch (Exception ex2) {
                        if (ex[0] == null) {
                            ex[0] = ex2;
                        }
                        ex[0].addSuppressed(ex2);
                    }
                }
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        };
    }

    default public ThrowingRunnable andThenIfNotNull(Supplier<?> test, ThrowingRunnable run) {
        return () -> {
            this.run();
            if (test.get() != null) {
                run.run();
            }
        };
    }

    default public ThrowingRunnable andThenIf(BooleanSupplier test, ThrowingRunnable run) {
        return () -> {
            this.run();
            if (test.getAsBoolean()) {
                run.run();
            }
        };
    }

    default public ThrowingRunnable andThen(Runnable run) {
        return () -> {
            this.run();
            run.run();
        };
    }

    default public ThrowingRunnable andThen(Callable<Void> run) {
        return () -> {
            this.run();
            run.call();
        };
    }

    default public ThrowingSupplier<Void> toThrowingSupplier() {
        return () -> {
            this.run();
            return null;
        };
    }

    default public <T> ThrowingSupplier<T> toThrowingSupplier(T obj) {
        return () -> {
            this.run();
            return obj;
        };
    }

    default public void addAsShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this.toRunnable()));
    }

    public static ThrowingRunnable fromAutoCloseable(AutoCloseable e) {
        return e::close;
    }
}

