/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing.io;

import com.mastfrog.function.throwing.ThrowingIntSupplier;
import java.io.IOException;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;

@FunctionalInterface
public interface IOIntSupplier
extends ThrowingIntSupplier {
    @Override
    public int getAsInt() throws IOException;

    @Override
    default public IOIntSupplier or(IntPredicate test, IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return test.test(result) ? result : next.getAsInt();
        };
    }

    @Override
    default public IOIntSupplier ifZero(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? next.getAsInt() : result;
        };
    }

    @Override
    default public IOIntSupplier plus(IntSupplier next) {
        return () -> this.getAsInt() + next.getAsInt();
    }

    @Override
    default public IOIntSupplier times(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? 0 : result * next.getAsInt();
        };
    }

    @Override
    default public IOIntSupplier minus(IntSupplier next) {
        return () -> this.getAsInt() - next.getAsInt();
    }

    @Override
    default public IOIntSupplier mod(IntSupplier next) {
        return () -> this.getAsInt() % next.getAsInt();
    }

    @Override
    default public IOIntSupplier bitwiseOr(IntSupplier next) {
        return () -> this.getAsInt() | next.getAsInt();
    }

    @Override
    default public IOIntSupplier bitwiseXor(IntSupplier next) {
        return () -> this.getAsInt() ^ next.getAsInt();
    }

    @Override
    default public IOIntSupplier bitwiseAnd(IntSupplier next) {
        return () -> this.getAsInt() & next.getAsInt();
    }

    @Override
    default public IOIntSupplier dividedBy(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            int div = next.getAsInt();
            return result == 0 || div == 0 ? 0 : result / div;
        };
    }

    default public IOIntSupplier or(IntPredicate test, IOIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return test.test(result) ? result : next.getAsInt();
        };
    }

    default public IOIntSupplier ifZero(IOIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? next.getAsInt() : result;
        };
    }

    default public IOIntSupplier plus(IOIntSupplier next) {
        return () -> this.getAsInt() + next.getAsInt();
    }

    default public IOIntSupplier times(IOIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? 0 : result * next.getAsInt();
        };
    }

    default public IOIntSupplier minus(IOIntSupplier next) {
        return () -> this.getAsInt() - next.getAsInt();
    }

    default public IOIntSupplier mod(IOIntSupplier next) {
        return () -> this.getAsInt() % next.getAsInt();
    }

    default public IOIntSupplier bitwiseOr(IOIntSupplier next) {
        return () -> this.getAsInt() | next.getAsInt();
    }

    default public IOIntSupplier bitwiseXor(IOIntSupplier next) {
        return () -> this.getAsInt() ^ next.getAsInt();
    }

    default public IOIntSupplier bitwiseAnd(IOIntSupplier next) {
        return () -> this.getAsInt() & next.getAsInt();
    }

    default public IOIntSupplier dividedBy(IOIntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            int div = next.getAsInt();
            return result == 0 || div == 0 ? 0 : result / div;
        };
    }
}

