/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function.throwing.io;

import com.mastfrog.function.throwing.ThrowingLongSupplier;
import com.mastfrog.function.throwing.io.IOSupplier;
import java.io.IOException;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;

@FunctionalInterface
public interface IOLongSupplier
extends ThrowingLongSupplier {
    @Override
    public long getAsLong() throws IOException;

    @Override
    default public IOLongSupplier or(LongPredicate test, LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return test.test(result) ? result : next.getAsLong();
        };
    }

    @Override
    default public IOLongSupplier ifZero(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? next.getAsLong() : result;
        };
    }

    @Override
    default public IOLongSupplier plus(LongSupplier next) {
        return () -> this.getAsLong() + next.getAsLong();
    }

    @Override
    default public IOLongSupplier times(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? 0L : result * next.getAsLong();
        };
    }

    @Override
    default public IOLongSupplier minus(LongSupplier next) {
        return () -> this.getAsLong() - next.getAsLong();
    }

    @Override
    default public IOLongSupplier mod(LongSupplier next) {
        return () -> this.getAsLong() % next.getAsLong();
    }

    @Override
    default public IOLongSupplier bitwiseOr(LongSupplier next) {
        return () -> this.getAsLong() | next.getAsLong();
    }

    @Override
    default public IOLongSupplier bitwiseXor(LongSupplier next) {
        return () -> this.getAsLong() ^ next.getAsLong();
    }

    @Override
    default public IOLongSupplier bitwiseAnd(LongSupplier next) {
        return () -> this.getAsLong() & next.getAsLong();
    }

    @Override
    default public IOLongSupplier dividedBy(LongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            long div = next.getAsLong();
            return result == 0L || div == 0L ? 0L : result / div;
        };
    }

    default public IOLongSupplier or(LongPredicate test, IOLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return test.test(result) ? result : next.getAsLong();
        };
    }

    default public IOLongSupplier ifZero(IOLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? next.getAsLong() : result;
        };
    }

    default public IOLongSupplier plus(IOLongSupplier next) {
        return () -> this.getAsLong() + next.getAsLong();
    }

    default public IOLongSupplier times(IOLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            return result == 0L ? 0L : result * next.getAsLong();
        };
    }

    default public IOLongSupplier minus(IOLongSupplier next) {
        return () -> this.getAsLong() - next.getAsLong();
    }

    default public IOLongSupplier mod(IOLongSupplier next) {
        return () -> this.getAsLong() % next.getAsLong();
    }

    default public IOLongSupplier bitwiseOr(IOLongSupplier next) {
        return () -> this.getAsLong() | next.getAsLong();
    }

    default public IOLongSupplier bitwiseXor(IOLongSupplier next) {
        return () -> this.getAsLong() ^ next.getAsLong();
    }

    default public IOLongSupplier bitwiseAnd(IOLongSupplier next) {
        return () -> this.getAsLong() & next.getAsLong();
    }

    default public IOLongSupplier dividedBy(IOLongSupplier next) {
        return () -> {
            long result = this.getAsLong();
            long div = next.getAsLong();
            return result == 0L || div == 0L ? 0L : result / div;
        };
    }

    default public IOSupplier<Long> toBoxedSupplier() {
        return () -> this.getAsLong();
    }
}

