/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.crawler.spring.collector;

import com.maxxton.microdocs.core.builder.PathBuilder;
import com.maxxton.microdocs.core.collector.Collector;
import com.maxxton.microdocs.core.collector.SchemaCollector;
import com.maxxton.microdocs.core.domain.path.Parameter;
import com.maxxton.microdocs.core.domain.path.ParameterBody;
import com.maxxton.microdocs.core.domain.path.ParameterPlacing;
import com.maxxton.microdocs.core.domain.path.ParameterVariable;
import com.maxxton.microdocs.core.domain.path.Response;
import com.maxxton.microdocs.core.domain.schema.Schema;
import com.maxxton.microdocs.core.reflect.ReflectAnnotation;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.core.reflect.ReflectDescriptionTag;
import com.maxxton.microdocs.core.reflect.ReflectMethod;
import com.maxxton.microdocs.core.reflect.ReflectParameter;
import com.maxxton.microdocs.crawler.ErrorReporter;
import com.maxxton.microdocs.crawler.spring.collector.RequestParser;
import com.maxxton.microdocs.crawler.spring.parser.PageableParser;
import com.maxxton.microdocs.crawler.spring.parser.SpecificationsParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PathCollector
implements Collector<PathBuilder> {
    private final String[] defaultConsumes = new String[]{"application/json"};
    private final String[] defaultProduces = new String[]{"application/json"};
    private static final String TYPE_REQUEST_BODY = "org.springframework.web.bind.annotation.RequestBody";
    private static final String TYPE_REQUEST_PARAM = "org.springframework.web.bind.annotation.RequestParam";
    private static final String TYPE_PATH_VARIABLE = "org.springframework.web.bind.annotation.PathVariable";
    private SchemaCollector schemaCollector;
    private final String[] controllers;
    private final String requestMapping;
    private final RequestParser[] requestParsers = new RequestParser[]{new PageableParser(), new SpecificationsParser()};

    public PathCollector(SchemaCollector schemaCollector, String[] controllers, String requestMapping) {
        this.schemaCollector = schemaCollector;
        this.controllers = controllers;
        this.requestMapping = requestMapping;
    }

    @Override
    public List<PathBuilder> collect(List<ReflectClass<?>> classes) {
        ArrayList<PathBuilder> pathBuilders = new ArrayList<PathBuilder>();
        classes.stream().filter(reflectClass -> reflectClass.hasAnnotation(this.controllers)).forEach(controller -> {
            ErrorReporter.get().printNotice("Crawl controller: " + controller.getSimpleName());
            controller.getDeclaredMethods().stream().filter(method -> method.hasAnnotation(this.requestMapping)).forEach(method -> {
                ErrorReporter.get().printNotice("Crawl controller method: " + method.getSimpleName());
                pathBuilders.addAll(this.collectPaths((ReflectClass<?>)controller, (ReflectMethod)method));
            });
        });
        return pathBuilders;
    }

    private List<PathBuilder> collectPaths(ReflectClass<?> controller, ReflectMethod method) {
        String path;
        ReflectAnnotation controllerRequestMapping = controller.getAnnotation(this.requestMapping);
        ReflectAnnotation methodRequestMapping = method.getAnnotation(this.requestMapping);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String controllerPath = this.getPath(controllerRequestMapping);
        String methodPath = this.getPath(methodRequestMapping);
        String fullPath = (controllerPath + "/" + methodPath).replace("\\\\", "/").replace("//", "/");
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        if (fullPath.contains("?")) {
            String[] params;
            String[] pathSplit = fullPath.split("\\?");
            path = pathSplit[0];
            String paramsSplit = pathSplit[1];
            String[] stringArray = params = paramsSplit.split("&");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                String[] paramSplit = string.split("=");
                ParameterVariable parameter = new ParameterVariable();
                parameter.setIn(ParameterPlacing.QUERY);
                parameter.setName(paramSplit[0]);
                parameter.setRequired(true);
                if (paramSplit.length > 1) {
                    parameter.setDefaultValue(paramSplit[1]);
                }
                parameters.add(parameter);
            }
        } else {
            path = fullPath;
        }
        HashSet<String> methods = new HashSet<String>();
        methods.addAll(this.getMethods(controllerRequestMapping));
        methods.addAll(this.getMethods(methodRequestMapping));
        if (methods.isEmpty()) {
            methods.add("get");
            methods.add("post");
            methods.add("put");
            methods.add("delete");
            methods.add("options");
            methods.add("head");
            methods.add("patch");
        }
        HashSet<String> produces = new HashSet<String>();
        for (String mime : this.defaultProduces) {
            produces.add(mime);
        }
        produces.addAll(this.getProduces(controllerRequestMapping));
        produces.addAll(this.getProduces(methodRequestMapping));
        HashSet<String> consumes = new HashSet<String>();
        for (String string : this.defaultConsumes) {
            consumes.add(string);
        }
        consumes.addAll(this.getCondumes(controllerRequestMapping));
        consumes.addAll(this.getCondumes(methodRequestMapping));
        for (ReflectParameter parameter : method.getParameters()) {
            ParameterVariable param;
            ReflectAnnotation annotation;
            if (parameter.getType() != null && parameter.getType().getClassType() != null) {
                RequestParser parser = null;
                for (RequestParser requestParser : this.requestParsers) {
                    if (!requestParser.getClassName().equals(parameter.getType().getClassType().getName()) && !requestParser.getClassName().equals(parameter.getType().getClassType().getSimpleName())) continue;
                    parser = requestParser;
                    break;
                }
                if (parser != null) {
                    List<Parameter> list = parser.parse(parameter, controller, method, this.schemaCollector);
                    parameters.addAll(list);
                    continue;
                }
            }
            String name = parameter.getName();
            Schema schema = this.schemaCollector.collect(parameter.getType());
            String description = null;
            for (ReflectDescriptionTag tag2 : method.getDescription().getTags("param")) {
                if (!name.equals(tag2.getKeyword())) continue;
                description = tag2.getDescription();
                break;
            }
            if (parameter.hasAnnotation(TYPE_REQUEST_BODY)) {
                ParameterBody bodyParam = new ParameterBody();
                bodyParam.setSchema(schema);
                bodyParam.setName(name);
                bodyParam.setDescription(description);
                bodyParam.setIn(ParameterPlacing.BODY);
                parameters.add(bodyParam);
                continue;
            }
            if (parameter.hasAnnotation(TYPE_REQUEST_PARAM)) {
                annotation = parameter.getAnnotation(TYPE_REQUEST_PARAM);
                param = new ParameterVariable();
                param.setIn(ParameterPlacing.QUERY);
                if (annotation.has("value")) {
                    name = annotation.getString("value");
                } else if (annotation.has("name")) {
                    name = annotation.getString("name");
                }
                param.setName(name);
                param.setDescription(description);
                param.setRequired(annotation.getBoolean("required"));
                param.setDefaultValue(annotation.getString("defaultValue"));
                param.setType(schema != null ? schema.getType() : null);
                parameters.add(param);
                continue;
            }
            if (!parameter.hasAnnotation(TYPE_PATH_VARIABLE)) continue;
            annotation = parameter.getAnnotation(TYPE_PATH_VARIABLE);
            param = new ParameterVariable();
            param.setIn(ParameterPlacing.PATH);
            if (annotation.has("value")) {
                name = annotation.getString("value");
            } else if (annotation.has("name")) {
                name = annotation.getString("name");
            }
            param.setName(name);
            param.setDescription(description);
            param.setRequired(true);
            param.setType(schema != null ? schema.getType() : null);
            parameters.add(param);
        }
        HashMap<String, Response> responses = new HashMap<String, Response>();
        if (method.getReturnType() != null && method.getReturnType().getClassType() != null && !method.getReturnType().getClassType().getSimpleName().equalsIgnoreCase("void")) {
            Response response = new Response();
            Iterator<ReflectDescriptionTag> name = method.getDescription().getTags("return").iterator();
            if (name.hasNext()) {
                ReflectDescriptionTag reflectDescriptionTag = name.next();
                response.setDescription(reflectDescriptionTag.getKeyword() + " " + reflectDescriptionTag.getDescription());
            }
            Schema schema = this.schemaCollector.collect(method.getReturnType());
            response.setSchema(schema);
            responses.put("default", response);
        }
        List<ReflectDescriptionTag> responseTags = method.getDescription().getTags("response");
        responseTags.forEach(tag -> {
            String responseCode = tag.getKeyword();
            Response response = new Response();
            response.setDescription(tag.getDescription());
            responses.put(responseCode, response);
        });
        ArrayList<PathBuilder> pathBuilders = new ArrayList<PathBuilder>();
        for (String requestMethod : methods) {
            PathBuilder builder = new PathBuilder();
            builder.path(path);
            builder.requestMethod(requestMethod);
            builder.component(controller);
            builder.method(method);
            builder.description(method.getDescription().getText());
            builder.operationId(method.getSimpleName());
            builder.parameters(parameters);
            builder.responses(responses);
            builder.consumes(consumes.stream().collect(Collectors.toList()));
            builder.produces(produces.stream().collect(Collectors.toList()));
            pathBuilders.add(builder);
        }
        return pathBuilders;
    }

    private String getPath(ReflectAnnotation requestMapping) {
        if (requestMapping != null) {
            if (requestMapping.has("value")) {
                return requestMapping.getString("value");
            }
            if (requestMapping.has("path")) {
                return requestMapping.getString("path");
            }
        }
        return "";
    }

    private Set<String> getMethods(ReflectAnnotation requestMapping) {
        String[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        if (requestMapping != null && (methods = requestMapping.getArray("method")) != null) {
            for (String method : methods) {
                if (!method.startsWith("org.springframework.web.bind.annotation.RequestMethod.")) continue;
                methodSet.add(method.substring("org.springframework.web.bind.annotation.RequestMethod.".length()).toLowerCase());
            }
        }
        return methodSet;
    }

    private Set<String> getProduces(ReflectAnnotation requestMapping) {
        String[] mimes;
        HashSet<String> produces = new HashSet<String>();
        if (requestMapping != null && requestMapping.has("produces") && (mimes = requestMapping.getArray("produces")) != null) {
            for (String mime : mimes) {
                produces.add(mime);
            }
        }
        return produces;
    }

    private Set<String> getCondumes(ReflectAnnotation requestMapping) {
        String[] mimes;
        HashSet<String> produces = new HashSet<String>();
        if (requestMapping != null && requestMapping.has("consumes") && (mimes = requestMapping.getArray("consumes")) != null) {
            for (String mime : mimes) {
                produces.add(mime);
            }
        }
        return produces;
    }
}

