/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.builder;

import com.maxxton.microdocs.core.builder.Builder;
import com.maxxton.microdocs.core.builder.DependencyBuilder;
import com.maxxton.microdocs.core.builder.PathBuilder;
import com.maxxton.microdocs.core.builder.ProjectInfoBuilder;
import com.maxxton.microdocs.core.domain.Project;
import com.maxxton.microdocs.core.domain.common.ExternalDocs;
import com.maxxton.microdocs.core.domain.common.ProjectInfo;
import com.maxxton.microdocs.core.domain.common.SecurityDefinition;
import com.maxxton.microdocs.core.domain.common.Tag;
import com.maxxton.microdocs.core.domain.component.Component;
import com.maxxton.microdocs.core.domain.component.ComponentType;
import com.maxxton.microdocs.core.domain.dependency.Dependency;
import com.maxxton.microdocs.core.domain.path.Parameter;
import com.maxxton.microdocs.core.domain.path.Path;
import com.maxxton.microdocs.core.domain.path.Response;
import com.maxxton.microdocs.core.domain.problem.Problem;
import com.maxxton.microdocs.core.domain.schema.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectBuilder
implements Builder<Project> {
    private Project project = new Project();
    private List<String> projectClasses;

    @Override
    public Project build() {
        return this.project;
    }

    public List<String> projectClasses() {
        return this.projectClasses;
    }

    public ProjectBuilder projectClasses(List<String> projectClasses) {
        this.projectClasses = projectClasses;
        return this;
    }

    public ProjectBuilder projectClass(String projectClass) {
        if (this.projectClasses == null) {
            this.projectClasses = new ArrayList<String>();
        }
        this.projectClasses.add(projectClass);
        return this;
    }

    public ProjectBuilder info(ProjectInfo info) {
        this.project.setInfo(info);
        return this;
    }

    public ProjectBuilder info(ProjectInfoBuilder projectInfoBuilder) {
        this.project.setInfo(projectInfoBuilder.build());
        return this;
    }

    public ProjectBuilder host(String host) {
        this.project.setHost(host);
        return this;
    }

    public ProjectBuilder basePath(String basePath) {
        this.project.setBasePath(basePath);
        return this;
    }

    public ProjectBuilder schemas(String ... schemas) {
        if (this.project.getSchemas() == null) {
            this.project.setSchemas(new ArrayList<String>());
        }
        for (String schema : schemas) {
            this.project.getSchemas().add(schema);
        }
        return this;
    }

    public ProjectBuilder schemas(List<String> schemas) {
        if (this.project.getSchemas() == null) {
            this.project.setSchemas(new ArrayList<String>());
        }
        this.project.getSchemas().addAll(schemas);
        return this;
    }

    public ProjectBuilder tag(String name) {
        this.tag(name, null, null);
        return this;
    }

    public ProjectBuilder tag(String name, String description) {
        this.tag(name, description, null);
        return this;
    }

    public ProjectBuilder tag(String name, String description, String externalDocUrl) {
        this.tag(name, description, externalDocUrl, null);
        return this;
    }

    public ProjectBuilder tag(String name, String description, String externalDocUrl, String externalDocDescription) {
        Tag tag = new Tag();
        tag.setName(name);
        tag.setDescription(description);
        if (externalDocUrl != null) {
            ExternalDocs externalDocs = new ExternalDocs();
            externalDocs.setUrl(externalDocUrl);
            externalDocs.setDescription(externalDocDescription);
            tag.setExternalDocs(externalDocs);
        }
        this.tag(tag);
        return this;
    }

    public ProjectBuilder tag(Tag tag) {
        if (this.project.getTags() == null) {
            this.project.setTags(new ArrayList<Tag>());
        }
        this.project.getTags().add(tag);
        return this;
    }

    public ProjectBuilder tags(Tag ... tags) {
        if (this.project.getTags() == null) {
            this.project.setTags(new ArrayList<Tag>());
        }
        for (Tag tag : tags) {
            this.project.getTags().add(tag);
        }
        return this;
    }

    public ProjectBuilder tags(List<Tag> tags) {
        if (this.project.getTags() == null) {
            this.project.setTags(new ArrayList<Tag>());
        }
        this.project.getTags().addAll(tags);
        return this;
    }

    public ProjectBuilder externalDoc(String url) {
        this.externalDoc(url, null);
        return this;
    }

    public ProjectBuilder externalDoc(String url, String description) {
        ExternalDocs externalDocs = new ExternalDocs();
        externalDocs.setUrl(url);
        externalDocs.setDescription(description);
        this.externalDoc(externalDocs);
        return this;
    }

    public ProjectBuilder externalDoc(ExternalDocs externalDocs) {
        if (this.project.getExternalDocs() == null) {
            this.project.setExternalDocs(new ArrayList<ExternalDocs>());
        }
        this.project.getExternalDocs().add(externalDocs);
        return this;
    }

    public ProjectBuilder externalDocs(ExternalDocs ... externalDocs) {
        if (this.project.getExternalDocs() == null) {
            this.project.setExternalDocs(new ArrayList<ExternalDocs>());
        }
        for (ExternalDocs externalDoc : externalDocs) {
            this.project.getExternalDocs().add(externalDoc);
        }
        return this;
    }

    public ProjectBuilder externalDocs(List<ExternalDocs> externalDocs) {
        if (this.project.getExternalDocs() == null) {
            this.project.setExternalDocs(new ArrayList<ExternalDocs>());
        }
        this.project.getExternalDocs().addAll(externalDocs);
        return this;
    }

    public ProjectBuilder securityDefinitions(String name, SecurityDefinition securityDefinition) {
        if (this.project.getSecurityDefinitions() == null) {
            this.project.setSecurityDefinitions(new HashMap<String, SecurityDefinition>());
        }
        this.project.getSecurityDefinitions().put(name, securityDefinition);
        return this;
    }

    public ProjectBuilder security(String name, String ... scopes) {
        ArrayList<String> scopeList = new ArrayList<String>();
        for (String scope : scopes) {
            scopeList.add(scope);
        }
        this.security(name, scopeList);
        return this;
    }

    public ProjectBuilder security(String name, List<String> scopeList) {
        if (this.project.getSecurity() == null) {
            this.project.setSecurity(new HashMap<String, List<String>>());
        }
        this.project.getSecurity().put(name, scopeList);
        return this;
    }

    public ProjectBuilder consumes(String ... consumes) {
        ArrayList<String> consumeList = new ArrayList<String>();
        for (String consume : consumes) {
            consumeList.add(consume);
        }
        this.consumes(consumeList);
        return this;
    }

    public ProjectBuilder consumes(List<String> consumes) {
        if (this.project.getConsumes() == null) {
            this.project.setConsumes(new ArrayList<String>());
        }
        this.project.getConsumes().addAll(consumes);
        return this;
    }

    public ProjectBuilder produces(String ... produces) {
        ArrayList<String> produceList = new ArrayList<String>();
        for (String produce : produces) {
            produceList.add(produce);
        }
        this.produces(produceList);
        return this;
    }

    public ProjectBuilder produces(List<String> produces) {
        if (this.project.getProduces() == null) {
            this.project.setProduces(new ArrayList<String>());
        }
        this.project.getProduces().addAll(produces);
        return this;
    }

    public ProjectBuilder path(PathBuilder pathBuilder) {
        this.path(pathBuilder.path(), pathBuilder.requestMethod(), pathBuilder.build());
        return this;
    }

    public ProjectBuilder path(String path, String method, Path endpoint) {
        if (this.project.getPaths() == null) {
            this.project.setPaths(new HashMap<String, Map<String, Path>>());
        }
        if (this.project.getPaths().get(path) == null) {
            this.project.getPaths().put(path, new HashMap());
        }
        this.project.getPaths().get(path).put(method, endpoint);
        return this;
    }

    public ProjectBuilder definition(String name, Schema schema) {
        if (this.project.getDefinitions() == null) {
            this.project.setDefinitions(new HashMap<String, Schema>());
        }
        this.project.getDefinitions().put(name, schema);
        return this;
    }

    public ProjectBuilder parameter(String name, Parameter parameter) {
        if (this.project.getParameters() == null) {
            this.project.setParameters(new HashMap<String, Parameter>());
        }
        this.project.getParameters().put(name, parameter);
        return this;
    }

    public ProjectBuilder response(String name, Response response) {
        if (this.project.getResponses() == null) {
            this.project.setResponses(new HashMap<String, Response>());
        }
        this.project.getResponses().put(name, response);
        return this;
    }

    public ProjectBuilder component(String name, Component component) {
        if (this.project.getComponents() == null) {
            this.project.setComponents(new HashMap<String, Component>());
        }
        this.project.getComponents().put(name, component);
        if ((this.project.getInfo() == null || this.project.getInfo() != null && this.project.getInfo().getDescription() != null && !this.project.getInfo().getDescription().trim().isEmpty()) && component.getType() == ComponentType.APPLICATION && component.getDescription() != null && !component.getDescription().trim().isEmpty()) {
            this.info(new ProjectInfoBuilder().description(component.getDescription()).build());
        }
        return this;
    }

    public ProjectBuilder dependency(DependencyBuilder dependencyBuilder) {
        return this.dependency(dependencyBuilder.title(), dependencyBuilder.build());
    }

    public ProjectBuilder dependency(String name, Dependency dependency) {
        if (this.project.getDependencies() == null) {
            this.project.setDependencies(new HashMap<String, Dependency>());
        }
        if (this.project.getDependencies().containsKey(name.toLowerCase())) {
            Dependency existingDependency = this.project.getDependencies().get(name.toLowerCase());
            if (existingDependency.getDescription() == null || existingDependency.getDescription().isEmpty()) {
                existingDependency.setDescription(dependency.getDescription());
            }
            dependency.getPaths().entrySet().forEach(entry -> {
                if (!existingDependency.getPaths().containsKey(entry.getKey())) {
                    existingDependency.getPaths().put((String)entry.getKey(), (Map<String, Path>)entry.getValue());
                } else {
                    ((Map)entry.getValue()).entrySet().forEach(subEntry -> existingDependency.getPaths().get(entry.getKey()).put((String)subEntry.getKey(), (Path)subEntry.getValue()));
                }
            });
        } else {
            this.project.getDependencies().put(name.toLowerCase(), dependency);
        }
        return this;
    }

    public ProjectBuilder problem(Problem problem) {
        if (this.project.getProblems() == null) {
            this.project.setProblems(new ArrayList<Problem>());
        }
        this.project.getProblems().add(problem);
        return this;
    }

    public ProjectBuilder problems(Problem ... problems) {
        ArrayList<Problem> problemList = new ArrayList<Problem>();
        for (Problem problem : problems) {
            problemList.add(problem);
        }
        this.problems(problemList);
        return this;
    }

    public ProjectBuilder problems(List<Problem> problems) {
        if (this.project.getProblems() == null) {
            this.project.setProblems(new ArrayList<Problem>());
        }
        this.project.getProblems().addAll(problems);
        return this;
    }
}

