/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.builder;

import com.maxxton.microdocs.core.builder.Builder;
import com.maxxton.microdocs.core.builder.PathBuilder;
import com.maxxton.microdocs.core.domain.component.Component;
import com.maxxton.microdocs.core.domain.dependency.Dependency;
import com.maxxton.microdocs.core.domain.dependency.DependencyType;
import com.maxxton.microdocs.core.domain.path.Path;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import java.util.HashMap;
import java.util.Map;

public class DependencyBuilder
implements Builder<Dependency> {
    private String title;
    private Dependency dependency = new Dependency();

    public String title() {
        return this.title;
    }

    public DependencyBuilder title(String title) {
        this.title = title.toLowerCase();
        return this;
    }

    public DependencyBuilder path(PathBuilder pathBuilder) {
        this.path(pathBuilder.path(), pathBuilder.requestMethod(), pathBuilder.build());
        return this;
    }

    public DependencyBuilder path(String path, String method, Path endpoint) {
        if (this.dependency.getPaths() == null) {
            this.dependency.setPaths(new HashMap<String, Map<String, Path>>());
        }
        if (this.dependency.getPaths().get(path) == null) {
            this.dependency.getPaths().put(path, new HashMap());
        }
        this.dependency.getPaths().get(path).put(method, endpoint);
        return this;
    }

    public DependencyBuilder group(String group) {
        this.dependency.setGroup(group);
        return this;
    }

    public DependencyBuilder description(String description) {
        this.dependency.setDescription(description);
        return this;
    }

    public DependencyBuilder component(ReflectClass controller) {
        return this.component(controller.getSimpleName());
    }

    public DependencyBuilder component(String controllerName) {
        Component component = new Component();
        component.setReference("#/components/" + controllerName);
        this.dependency.setComponent(component);
        return this;
    }

    public DependencyBuilder type(DependencyType type) {
        this.dependency.setType(type);
        return this;
    }

    public DependencyBuilder version(String version) {
        this.dependency.setVersion(version);
        return this;
    }

    public DependencyBuilder latestVersion(String latestVersion) {
        this.dependency.setLatestVersion(latestVersion);
        return this;
    }

    public DependencyBuilder protocol(String protocol) {
        this.dependency.setProtocol(protocol);
        return this;
    }

    @Override
    public Dependency build() {
        return this.dependency;
    }
}

