/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.reflect;

import com.maxxton.microdocs.core.reflect.ReflectDoc;
import java.util.HashMap;
import java.util.Map;

public class ReflectAnnotation
extends ReflectDoc {
    private String packageName;
    private Map<String, String> properties = new HashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean has(String property) {
        return this.properties.containsKey(property);
    }

    public String get(String property) {
        return this.properties.get(property);
    }

    public String getString(String property) {
        if (!this.has(property)) {
            return null;
        }
        String value = this.get(property).trim();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    public Integer getInt(String property) {
        if (this.getString(property) == null) {
            try {
                return Integer.parseInt(this.get(property));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Double getDouble(String property) {
        if (this.getString(property) == null) {
            try {
                return Double.parseDouble(this.get(property));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public boolean getBoolean(String property) {
        if (this.getString(property) == null) {
            try {
                return Boolean.parseBoolean(this.get(property));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public String[] getArray(String property) {
        if (!this.has(property)) {
            return null;
        }
        String value = this.get(property).trim();
        if (value.startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
            return value.split(",");
        }
        return new String[]{value};
    }
}

