/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.core.builder;

import com.maxxton.microdocs.core.builder.AnnotationBuilder;
import com.maxxton.microdocs.core.builder.Builder;
import com.maxxton.microdocs.core.builder.MethodBuilder;
import com.maxxton.microdocs.core.domain.component.Annotation;
import com.maxxton.microdocs.core.domain.component.Component;
import com.maxxton.microdocs.core.domain.component.ComponentType;
import com.maxxton.microdocs.core.domain.component.Method;
import com.maxxton.microdocs.core.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ComponentBuilder
implements Builder<Component> {
    private Component component = new Component();
    private String simpleName;

    public String simpleName() {
        return this.simpleName;
    }

    public ComponentBuilder simpleName(String name) {
        this.simpleName = name;
        return this;
    }

    public ComponentBuilder name(String name) {
        this.component.setName(name);
        return this;
    }

    public ComponentBuilder file(String file) {
        this.component.setFile(file);
        return this;
    }

    public ComponentBuilder type(ComponentType type) {
        this.component.setType(type);
        return this;
    }

    public ComponentBuilder description(String description) {
        this.component.setDescription(description);
        return this;
    }

    public ComponentBuilder authors(String ... authors) {
        ArrayList<String> authorList = new ArrayList<String>();
        for (String author : authors) {
            authorList.add(author);
        }
        return this.authors(authorList);
    }

    public ComponentBuilder authors(List<String> authors) {
        this.component.setAuthors(authors);
        return this;
    }

    public ComponentBuilder annotation(AnnotationBuilder annotationBuilder) {
        return this.annotation(annotationBuilder.name(), annotationBuilder.build());
    }

    public ComponentBuilder annotation(String name, Annotation annotation) {
        if (this.component.getAnnotations() == null) {
            this.component.setAnnotations(new HashMap<String, Annotation>());
        }
        if (name != null) {
            this.component.getAnnotations().put(name, annotation);
        } else {
            Logger.get().warning("Name annotation on " + this.component.getName() + " is empty");
        }
        return this;
    }

    public ComponentBuilder method(MethodBuilder methodBuilder) {
        this.method(methodBuilder.build());
        return this;
    }

    public ComponentBuilder method(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(method.getName() + "(");
        if (method.getParameters() != null) {
            for (String param : method.getParameters()) {
                stringBuilder.append(param + ",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(")");
        if (this.component.getMethods() == null) {
            this.component.setMethods(new HashMap<String, Method>());
        }
        this.component.getMethods().put(stringBuilder.toString(), method);
        return this;
    }

    public ComponentBuilder dependencies(ComponentBuilder component) {
        Component ref = new Component();
        ref.setReference("#/components/" + component.simpleName());
        this.component.getDependencies().add(ref);
        return this;
    }

    @Override
    public Component build() {
        return this.component;
    }
}

