/*
 * Decompiled with CFR 0.152.
 */
package com.maxxton.microdocs.crawler.spring;

import com.maxxton.microdocs.core.builder.ComponentBuilder;
import com.maxxton.microdocs.core.builder.DependencyBuilder;
import com.maxxton.microdocs.core.builder.PathBuilder;
import com.maxxton.microdocs.core.builder.ProjectBuilder;
import com.maxxton.microdocs.core.collector.ComponentCollector;
import com.maxxton.microdocs.core.collector.SchemaCollector;
import com.maxxton.microdocs.core.domain.Project;
import com.maxxton.microdocs.core.domain.component.ComponentType;
import com.maxxton.microdocs.core.domain.schema.Schema;
import com.maxxton.microdocs.core.reflect.ReflectClass;
import com.maxxton.microdocs.crawler.Crawler;
import com.maxxton.microdocs.crawler.spring.Types;
import com.maxxton.microdocs.crawler.spring.collector.DependencyCollector;
import com.maxxton.microdocs.crawler.spring.collector.PathCollector;
import com.maxxton.microdocs.crawler.spring.collector.SpringSchemaCollector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpringCrawler
extends Crawler {
    private final ComponentCollector componentCollector;
    private final SchemaCollector schemaCollector;
    private final PathCollector pathCollector;
    private final DependencyCollector dependencyCollector;

    public SpringCrawler() {
        HashMap<String, ComponentType> componentsMap = new HashMap<String, ComponentType>();
        componentsMap.put(Types.SERVICE.getClassName(), ComponentType.SERVICE);
        componentsMap.put(Types.COMPONENT.getClassName(), ComponentType.COMPONENT);
        componentsMap.put(Types.CONTROLLER.getClassName(), ComponentType.CONTROLLER);
        componentsMap.put(Types.REST_CONTROLLER.getClassName(), ComponentType.CONTROLLER);
        componentsMap.put(Types.REPOSITORY.getClassName(), ComponentType.REPOSITORY);
        componentsMap.put(Types.SPRING_BOOT_APPLICATION.getClassName(), ComponentType.APPLICATION);
        componentsMap.put(Types.CONFIGURATION.getClassName(), ComponentType.CONFIGURATION);
        componentsMap.put(Types.FEIGN_CLIENT.getClassName(), ComponentType.CLIENT);
        this.componentCollector = new ComponentCollector(componentsMap);
        this.schemaCollector = new SpringSchemaCollector();
        this.pathCollector = new PathCollector(this.schemaCollector, Types.REST_CONTROLLER);
        this.dependencyCollector = new DependencyCollector(this.schemaCollector);
    }

    @Override
    protected Project extractProject(ProjectBuilder project, List<ReflectClass<?>> classes) {
        List<ComponentBuilder> components = this.componentCollector.collect(classes);
        components.forEach(component -> project.component(component.simpleName(), component.build()));
        this.pathCollector.collect(classes).forEach(pathBuilder -> project.path((PathBuilder)pathBuilder));
        this.dependencyCollector.collect(classes).forEach(dependencyBuilder -> project.dependency((DependencyBuilder)dependencyBuilder));
        Map<String, Schema> schemas = this.schemaCollector.collect(classes);
        schemas.entrySet().forEach(entry -> project.definition((String)entry.getKey(), (Schema)entry.getValue()));
        return project.build();
    }
}

