/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool;

import com.menecats.polybool.Epsilon;
import com.menecats.polybool.helpers.PolyBoolHelper;

public class ExperimentalEpsilon
extends Epsilon {
    public ExperimentalEpsilon() {
    }

    public ExperimentalEpsilon(double eps) {
        super(eps);
    }

    @Override
    public boolean pointAboveOrOnLine(double[] pt, double[] left, double[] right) {
        double Bx = right[0];
        double Ax = left[0];
        double ABx = Bx - Ax;
        double Cy = pt[1];
        double Ay = left[1];
        double By = right[1];
        double ABy = By - Ay;
        double Cx = pt[0];
        double AB = Math.sqrt(ABx * ABx + ABy * ABy);
        return ABx * (Cy - Ay) - ABy * (Cx - Ax) >= -this.eps * AB;
    }

    @Override
    public boolean pointBetween(double[] p, double[] left, double[] right) {
        if (this.pointsSame(p, left) || this.pointsSame(p, right)) {
            return false;
        }
        double d_px_lx = p[0] - left[0];
        double d_rx_lx = right[0] - left[0];
        double d_py_ly = p[1] - left[1];
        double d_ry_ly = right[1] - left[1];
        double dot = d_px_lx * d_rx_lx + d_py_ly * d_ry_ly;
        if (dot < 0.0) {
            return false;
        }
        double sqlen = d_rx_lx * d_rx_lx + d_ry_ly * d_ry_ly;
        return dot <= sqlen;
    }

    @Override
    public boolean pointsCollinear(double[] pt1, double[] pt2, double[] pt3) {
        double dx1 = pt1[0] - pt2[0];
        double dy1 = pt1[1] - pt2[1];
        double dx2 = pt2[0] - pt3[0];
        double dy2 = pt2[1] - pt3[1];
        double n1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double n2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        return Math.abs(dx1 * dy2 - dx2 * dy1) <= this.eps * (n1 + n2);
    }

    @Override
    public Epsilon.EpsilonIntersectionResult linesIntersect(double[] a0, double[] a1, double[] b0, double[] b1) {
        double adx = a1[0] - a0[0];
        double ady = a1[1] - a0[1];
        double bdx = b1[0] - b0[0];
        double bdy = b1[1] - b0[1];
        double axb = adx * bdy - ady * bdx;
        double n1 = Math.sqrt(adx * adx + ady * ady);
        double n2 = Math.sqrt(bdx * bdx + bdy * bdy);
        if (Math.abs(axb) <= this.eps * (n1 + n2)) {
            return null;
        }
        double dx = a0[0] - b0[0];
        double dy = a0[1] - b0[1];
        double A = (bdx * dy - bdy * dx) / axb;
        double B = (adx * dy - ady * dx) / axb;
        double[] pt = PolyBoolHelper.point(a0[0] + A * adx, a0[1] + A * ady);
        Epsilon.EpsilonIntersectionResult ret = new Epsilon.EpsilonIntersectionResult();
        ret.pt = pt;
        if (this.pointsSame(pt, a0)) {
            ret.alongA = -1;
        } else if (this.pointsSame(pt, a1)) {
            ret.alongA = 1;
        } else if (A < 0.0) {
            ret.alongA = -2;
        } else if (A > 1.0) {
            ret.alongA = 2;
        }
        if (this.pointsSame(pt, b0)) {
            ret.alongB = -1;
        } else if (this.pointsSame(pt, b1)) {
            ret.alongB = 1;
        } else if (B < 0.0) {
            ret.alongB = -2;
        } else if (B > 1.0) {
            ret.alongB = 2;
        }
        return ret;
    }
}

