/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool.internal;

import com.menecats.polybool.Epsilon;
import com.menecats.polybool.PolyBool;
import com.menecats.polybool.helpers.PolyBoolHelper;
import com.menecats.polybool.models.Polygon;
import com.menecats.polybool.models.geojson.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class GeoJSON {
    public static Polygon toPolygon(Epsilon epsilon, Geometry<?> geojson) {
        Function<List, PolyBool.Segments> geoPoly = coords -> {
            if (coords.isEmpty()) {
                return PolyBool.segments(epsilon, new Polygon());
            }
            Function<List, PolyBool.Segments> lineString = ls -> {
                ArrayList region = new ArrayList(ls);
                region.remove(region.size() - 1);
                return PolyBool.segments(epsilon, new Polygon(Collections.singletonList(region)));
            };
            PolyBool.Segments out = lineString.apply((List)coords.get(0));
            for (int i = 1; i < coords.size(); ++i) {
                out = PolyBool.selectDifference(PolyBool.combine(epsilon, out, lineString.apply((List)coords.get(i))));
            }
            return out;
        };
        if ("Polygon".equals(geojson.getType())) {
            List coordinates = (List)geojson.getCoordinates();
            return PolyBool.polygon(epsilon, geoPoly.apply(coordinates));
        }
        if ("MultiPolygon".equals(geojson.getType())) {
            List coordinates = (List)geojson.getCoordinates();
            PolyBool.Segments out = PolyBool.segments(epsilon, new Polygon());
            for (List coordinate : coordinates) {
                out = PolyBool.selectUnion(PolyBool.combine(epsilon, out, geoPoly.apply(coordinate)));
            }
            return PolyBool.polygon(epsilon, out);
        }
        throw new IllegalArgumentException("PolyBool: Cannot convert GeoJSON object to PolyBool polygon");
    }

    public static Geometry<?> fromPolygon(Epsilon epsilon, Polygon poly) {
        poly = PolyBool.polygon(epsilon, PolyBool.segments(epsilon, poly));
        Node roots = new Node(null);
        for (int i = 0; i < poly.getRegions().size(); ++i) {
            List<double[]> region = poly.getRegions().get(i);
            if (region.size() < 3) continue;
            GeoJSON.fromPolygon_addChild(epsilon, roots, region);
        }
        ArrayList<List<List<double[]>>> geopolys = new ArrayList<List<List<double[]>>>();
        for (int i = 0; i < roots.children.size(); ++i) {
            GeoJSON.fromPolygon_addExterior(geopolys, (Node)roots.children.get(i));
        }
        if (geopolys.isEmpty()) {
            return new Geometry.PolygonGeometry();
        }
        if (geopolys.size() == 1) {
            return new Geometry.PolygonGeometry((List)geopolys.get(0));
        }
        return new Geometry.MultiPolygonGeometry((List<List<List<double[]>>>)geopolys);
    }

    private static boolean fromPolygon_regionInsideRegion(Epsilon epsilon, List<double[]> r1, List<double[]> r2) {
        return epsilon.pointInsideRegion(PolyBoolHelper.point((r1.get(0)[0] + r1.get(1)[0]) * 0.5, (r1.get(0)[1] + r1.get(1)[1]) * 0.5), r2);
    }

    private static void fromPolygon_addChild(Epsilon epsilon, Node root, List<double[]> region) {
        for (int i = 0; i < root.children.size(); ++i) {
            Node child = (Node)root.children.get(i);
            if (!GeoJSON.fromPolygon_regionInsideRegion(epsilon, region, child.region)) continue;
            GeoJSON.fromPolygon_addChild(epsilon, child, region);
            return;
        }
        Node node = new Node(region);
        for (int i = 0; i < root.children.size(); ++i) {
            Node child = (Node)root.children.get(i);
            if (!GeoJSON.fromPolygon_regionInsideRegion(epsilon, child.region, region)) continue;
            node.children.add(child);
            root.children.remove(i);
            --i;
        }
        root.children.add(node);
    }

    private static List<double[]> fromPolygon_forceWinding(List<double[]> region, boolean clockwise) {
        boolean isclockwise;
        int winding = 0;
        double last_x = region.get(region.size() - 1)[0];
        double last_y = region.get(region.size() - 1)[1];
        ArrayList<double[]> copy = new ArrayList<double[]>();
        for (double[] point : region) {
            double curr_x = point[0];
            double curr_y = point[1];
            copy.add(PolyBoolHelper.point(curr_x, curr_y));
            winding = (int)((double)winding + (curr_y * last_x - curr_x * last_y));
            last_x = curr_x;
            last_y = curr_y;
        }
        boolean bl = isclockwise = winding < 0;
        if (isclockwise != clockwise) {
            Collections.reverse(copy);
        }
        copy.add(PolyBoolHelper.point(((double[])copy.get(0))[0], ((double[])copy.get(0))[1]));
        return copy;
    }

    private static void fromPolygon_addExterior(List<List<List<double[]>>> geopolys, Node node) {
        ArrayList<List<double[]>> p = new ArrayList<List<double[]>>();
        p.add(GeoJSON.fromPolygon_forceWinding(node.region, false));
        geopolys.add(p);
        for (int i = 0; i < node.children.size(); ++i) {
            p.add(GeoJSON.fromPolygon_getInterior(geopolys, (Node)node.children.get(i)));
        }
    }

    private static List<double[]> fromPolygon_getInterior(List<List<List<double[]>>> geopolys, Node node) {
        for (int i = 0; i < node.children.size(); ++i) {
            GeoJSON.fromPolygon_addExterior(geopolys, (Node)node.children.get(i));
        }
        return GeoJSON.fromPolygon_forceWinding(node.region, true);
    }

    private GeoJSON() {
    }

    private static class Node {
        private final List<double[]> region;
        private final List<Node> children;

        private Node(List<double[]> region) {
            this.region = region;
            this.children = new ArrayList<Node>();
        }
    }
}

