/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.examples.spring;

import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.loader.simple.SimpleLoader;
import com.metaobjects.object.MetaObject;
import com.metaobjects.registry.MetaDataLoaderRegistry;
import com.metaobjects.spring.MetaDataService;
import com.metaobjects.util.MetaDataUtil;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class SpringMetaObjectsExample
implements CommandLineRunner {
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private MetaDataLoader primaryMetaDataLoader;
    @Autowired
    private MetaDataLoaderRegistry metaDataLoaderRegistry;

    public static void main(String[] args) {
        try {
            System.out.println("=== Testing Spring Integration Manually ===");
            SpringMetaObjectsExample.testSpringIntegrationManually();
        }
        catch (Exception e) {
            System.err.println("Spring integration test failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void testSpringIntegrationManually() throws Exception {
        System.out.println("\n1. Spring class loading verification...");
        try {
            Class.forName("com.metaobjects.spring.MetaDataAutoConfiguration");
            Class.forName("com.metaobjects.spring.MetaDataService");
            Class.forName("com.metaobjects.spring.MetaDataLoaderConfiguration");
            System.out.println("   Spring integration classes: SUCCESS");
        }
        catch (Exception e) {
            System.out.println("   Spring class loading failed: " + e.getMessage());
        }
        System.out.println("\n2. Basic MetaObjects functionality...");
        SimpleLoader loader = new SimpleLoader("spring-test");
        URL resourceUrl = SpringMetaObjectsExample.class.getResource("/metadata/examples-metadata.json");
        if (resourceUrl == null) {
            throw new RuntimeException("Could not find metadata resource");
        }
        Path tempFile = Files.createTempFile("examples-metadata", ".json", new FileAttribute[0]);
        try (InputStream is = resourceUrl.openStream();){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        loader.setSourceURIs(Arrays.asList(tempFile.toUri()));
        loader.init();
        System.out.println("   Loaded " + loader.getChildren().size() + " metadata items");
        try {
            MetaObject userMeta = MetaDataUtil.findMetaObjectByName((MetaDataLoader)loader, (String)"com_example_model::User");
            System.out.println("   Found User MetaObject: " + userMeta.getName());
            System.out.println("   User has " + userMeta.getMetaFields().size() + " fields");
        }
        catch (Exception e) {
            System.out.println("   MetaObject lookup failed: " + e.getMessage());
        }
        System.out.println("\n=== Manual Spring integration test completed ===");
    }

    public void run(String ... args) throws Exception {
        System.out.println("=== MetaObjects Spring Example ===");
        this.demonstrateSpringIntegration();
    }

    private void demonstrateSpringIntegration() {
        System.out.println("\n1. Spring auto-configuration verification...");
        System.out.println("   MetaDataService injected: " + (this.metaDataService != null ? "SUCCESS" : "FAILED"));
        System.out.println("   Primary MetaDataLoader injected: " + (this.primaryMetaDataLoader != null ? "SUCCESS" : "FAILED"));
        System.out.println("   MetaDataLoaderRegistry injected: " + (this.metaDataLoaderRegistry != null ? "SUCCESS" : "FAILED"));
        System.out.println("\n2. Using MetaDataService wrapper...");
        Collection allObjects = this.metaDataService.getAllMetaObjects();
        System.out.println("   Found " + allObjects.size() + " MetaObjects via service");
        for (MetaObject obj : allObjects) {
            System.out.println("     - " + obj.getName() + " (package: " + obj.getPackage() + ")");
        }
        Optional userMeta = this.metaDataService.findMetaObjectByNameOptional("com_example_model::User");
        if (userMeta.isPresent()) {
            System.out.println("   User MetaObject found via optional access");
            System.out.println("     Fields: " + ((MetaObject)userMeta.get()).getMetaFields().size());
        } else {
            System.out.println("   User MetaObject not found");
        }
        boolean hasUser = this.metaDataService.metaObjectExists("com_example_model::User");
        boolean hasProduct = this.metaDataService.metaObjectExists("com_example_model::Product");
        System.out.println("   User exists: " + hasUser + ", Product exists: " + hasProduct);
        System.out.println("\n3. Simple pattern - direct loader access...");
        System.out.println("   Primary loader name: " + this.primaryMetaDataLoader.getName());
        System.out.println("   Primary loader objects: " + this.primaryMetaDataLoader.getChildren(MetaObject.class).size());
        try {
            MetaObject directUser = MetaDataUtil.findMetaObjectByName((MetaDataLoader)this.primaryMetaDataLoader, (String)"com_example_model::User");
            System.out.println("   Direct loader lookup: " + directUser.getName());
        }
        catch (Exception e) {
            System.out.println("   Direct lookup failed: " + e.getMessage());
        }
        System.out.println("\n4. Complex pattern - registry operations...");
        System.out.println("   Total registered loaders: " + this.metaDataLoaderRegistry.getDataLoaders().size());
        for (MetaDataLoader loader : this.metaDataLoaderRegistry.getDataLoaders()) {
            System.out.println("     - Loader: " + loader.getName() + " (" + loader.getChildren().size() + " children)");
        }
        try {
            MetaObject registryUser = MetaDataUtil.findMetaObjectByName((String)"com_example_model::User", (Object)this);
            System.out.println("   Registry utility lookup: " + registryUser.getName());
        }
        catch (Exception e) {
            System.out.println("   Registry utility lookup failed: " + e.getMessage());
        }
        System.out.println("\n5. Service convenience methods (recommended for most Spring apps)...");
        try {
            MetaObject user = this.metaDataService.findMetaObjectByName("com_example_model::User");
            System.out.println("   Service lookup successful: " + user.getName());
            user.getMetaFields().forEach(field -> System.out.println("     Field: " + field.getName() + " (" + field.getSubType() + ")"));
        }
        catch (Exception e) {
            System.out.println("   Service lookup failed: " + e.getMessage());
        }
        System.out.println("\n=== Spring Example completed ===");
    }

    @Bean
    public MetaDataLoader exampleMetaDataLoader() throws Exception {
        SimpleLoader loader = new SimpleLoader("spring-example");
        URL resourceUrl = this.getClass().getResource("/metadata/examples-metadata.json");
        if (resourceUrl == null) {
            throw new RuntimeException("Could not find metadata resource: /metadata/examples-metadata.json");
        }
        Path tempFile = Files.createTempFile("examples-metadata", ".json", new FileAttribute[0]);
        try (InputStream is = resourceUrl.openStream();){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        URI metadataUri = tempFile.toUri();
        loader.setSourceURIs(Arrays.asList(metadataUri));
        loader.init();
        return loader;
    }
}

