/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;

public class BroadcastAddressData
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.broadcast.broadcastAddressData";
    private String address;
    private String newAddress;

    private BroadcastAddressData(String address, String newAddress) {
        this.address = address;
        this.newAddress = newAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public String getNewAddress() {
        return this.newAddress;
    }

    public static BroadcastAddressData create(String address, String newAddress) {
        return new BroadcastAddressData(address, newAddress);
    }

    public static BroadcastAddressData fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String address = null;
        if (dataRepresentation.hasProperty("address").booleanValue()) {
            try {
                address = dataRepresentation.getText("address");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String newAddress = null;
        if (dataRepresentation.hasProperty("newAddress").booleanValue()) {
            try {
                newAddress = dataRepresentation.getText("newAddress");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BroadcastAddressData broadcastAddressData = BroadcastAddressData.create(address, newAddress);
        return broadcastAddressData;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.address != null) {
            dataRepresentation.add("address", this.address);
        }
        if (this.newAddress != null) {
            dataRepresentation.add("newAddress", this.newAddress);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

