/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.Core;
import com.metaring.framework.SysKB;
import com.metaring.framework.broadcast.BroadcastController;
import com.metaring.framework.type.DataRepresentation;
import java.util.concurrent.CompletableFuture;

public final class BroadcastControllerManager {
    public static final CompletableFuture<BroadcastController> INSTANCE;

    static {
        SysKB sysKB = Core.SYSKB;
        if (sysKB == null) {
            INSTANCE = CompletableFuture.completedFuture(null);
        } else if (!sysKB.hasProperty("broadcast").booleanValue()) {
            INSTANCE = CompletableFuture.completedFuture(null);
        } else {
            DataRepresentation functionalityDataRepresentation = sysKB.get("broadcast");
            if (!functionalityDataRepresentation.hasProperty("controller").booleanValue()) {
                INSTANCE = null;
            } else {
                String className = functionalityDataRepresentation.getText("controller");
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("An error occurred while creating Broadcast Controller class " + className, e);
                }
                try {
                    CompletableFuture future = new CompletableFuture();
                    ((BroadcastController)clazz.newInstance()).init(sysKB).whenCompleteAsync((result, error) -> {
                        if (error != null) {
                            future.completeExceptionally((Throwable)error);
                        } else {
                            future.complete(result);
                        }
                    });
                    INSTANCE = future;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    throw new IllegalArgumentException("An error occurred while trying to access to Broadcast Controller init " + className, e);
                }
            }
        }
    }
}

