/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.broadcast.Event;
import com.metaring.framework.type.DataRepresentation;

public class SingleCallback
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.broadcast.singleCallback";
    private String address;
    private Event data;

    private SingleCallback(String address, Event data) {
        this.address = address;
        this.data = data;
    }

    public String getAddress() {
        return this.address;
    }

    public Event getData() {
        return this.data;
    }

    public static SingleCallback create(String address, Event data) {
        return new SingleCallback(address, data);
    }

    public static SingleCallback fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String address = null;
        if (dataRepresentation.hasProperty("address").booleanValue()) {
            try {
                address = dataRepresentation.getText("address");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Event data = null;
        if (dataRepresentation.hasProperty("data").booleanValue()) {
            try {
                data = (Event)dataRepresentation.get("data", Event.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SingleCallback singleCallback = SingleCallback.create(address, data);
        return singleCallback;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.address != null) {
            dataRepresentation.add("address", this.address);
        }
        if (this.data != null) {
            dataRepresentation.add("data", (CoreType)this.data);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

