/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.SysKB;
import com.metaring.framework.broadcast.BroadcastAddressData;
import com.metaring.framework.broadcast.Event;
import com.metaring.framework.broadcast.MultipleCallback;
import com.metaring.framework.broadcast.SingleCallback;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public interface BroadcastController {
    public static final String BROADCAST_KEY = "broadcast.key";
    public static final String CFG_BROADCAST = "broadcast";
    public static final String CFG_CONTROLLER = "controller";
    public static final String CALLBACK = "callback";
    public static final String CALLBACK_TO = "callback/to/";
    public static final String REGISTER = "callback/register/";
    public static final String UNREGISTER = "callback/unregister/";
    public static final String IS_SUBSCRIBED = "callback/isSubscribed/";

    default public CompletableFuture<BroadcastController> init(SysKB sysKB) {
        return CompletableFuture.completedFuture(this);
    }

    public CompletableFuture<Void> callback(SingleCallback var1, Executor var2);

    default public CompletableFuture<Void> callback(MultipleCallback multipleCallback, Executor asyncExecutor) {
        Runnable[] action;
        ArrayList addresses = new ArrayList(multipleCallback.getAddresses());
        CompletableFuture<Void> run = new CompletableFuture<Void>();
        action = new Runnable[]{() -> {
            if (addresses.isEmpty()) {
                run.complete(null);
                return;
            }
            this.callback(SingleCallback.create((String)addresses.remove(0), multipleCallback.getData()), asyncExecutor).thenRunAsync(action[0], asyncExecutor);
        }};
        action[0].run();
        return run;
    }

    public CompletableFuture<Void> callback(Event var1, Executor var2);

    public CompletableFuture<Void> subscribe(BroadcastAddressData var1, Executor var2);

    public CompletableFuture<Void> unsubscribe(BroadcastAddressData var1, Executor var2);

    public CompletableFuture<Boolean> isSubscribed(BroadcastAddressData var1, Executor var2);

    public BroadcastController register(String var1, BiConsumer<String, Exception> var2);

    public BroadcastController unregister(String var1);
}

