/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;

public class Event
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.broadcast.event";
    private String topic;
    private DataRepresentation payload;

    private Event(String topic, DataRepresentation payload) {
        this.topic = topic;
        this.payload = payload;
    }

    public String getTopic() {
        return this.topic;
    }

    public DataRepresentation getPayload() {
        return this.payload;
    }

    public static Event create(String topic, DataRepresentation payload) {
        return new Event(topic, payload);
    }

    public static Event fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String topic = null;
        if (dataRepresentation.hasProperty("topic").booleanValue()) {
            try {
                topic = dataRepresentation.getText("topic");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataRepresentation payload = null;
        if (dataRepresentation.hasProperty("payload").booleanValue()) {
            try {
                payload = dataRepresentation.get("payload");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Event event = Event.create(topic, payload);
        return event;
    }

    public static Event fromObject(Object object) {
        if (object == null) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromObject(object);
        String topic = null;
        if (dataRepresentation.hasProperty("topic").booleanValue()) {
            try {
                topic = dataRepresentation.getText("topic");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataRepresentation payload = null;
        if (dataRepresentation.hasProperty("payload").booleanValue()) {
            try {
                payload = dataRepresentation.get("payload");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Event event = Event.create(topic, payload);
        return event;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.topic != null) {
            dataRepresentation.add("topic", this.topic);
        }
        if (this.payload != null) {
            dataRepresentation.add("payload", this.payload);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

