/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.broadcast;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.broadcast.BroadcastAddressData;
import com.metaring.framework.broadcast.Event;
import com.metaring.framework.broadcast.MultipleCallback;
import com.metaring.framework.broadcast.SingleCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class BroadcastController {
    public static final String BROADCAST_KEY = "broadcast.key";
    private static final Map<String, Map<String, Consumer<String>>> DATABASE = new HashMap<String, Map<String, Consumer<String>>>();
    private static final Map<String, BiConsumer<String, GeneratedCoreType>> GLOBAL_HOOKS = new HashMap<String, BiConsumer<String, GeneratedCoreType>>();
    private static final CompletableFuture<Void> END = CompletableFuture.completedFuture(null);

    public static final CompletableFuture<Void> callback(SingleCallback singleCallback, Executor asyncExecutor) {
        String payload = singleCallback.getData().toJson();
        if (!DATABASE.containsKey(singleCallback.getAddress())) {
            return END;
        }
        BroadcastController.callHooks("singleCallback", singleCallback, asyncExecutor);
        return CompletableFuture.allOf((CompletableFuture[])DATABASE.get(singleCallback.getAddress()).values().stream().map(it -> CompletableFuture.runAsync(() -> it.accept(payload), asyncExecutor)).toArray(CompletableFuture[]::new));
    }

    public static final CompletableFuture<Void> callback(MultipleCallback multipleCallback, Executor asyncExecutor) {
        Runnable[] action;
        ArrayList addresses = new ArrayList(multipleCallback.getAddresses());
        CompletableFuture<Void> run = new CompletableFuture<Void>();
        action = new Runnable[]{() -> {
            if (addresses.isEmpty()) {
                run.complete(null);
                return;
            }
            BroadcastController.callback(SingleCallback.create((String)addresses.remove(0), multipleCallback.getData()), asyncExecutor).thenRunAsync(action[0], asyncExecutor);
        }};
        BroadcastController.callHooks("multipleCallback", multipleCallback, asyncExecutor);
        action[0].run();
        return run;
    }

    public static final CompletableFuture<Void> callback(Event event, Executor asyncExecutor) {
        String payload = event.toJson();
        BroadcastController.callHooks("event", event, asyncExecutor);
        return CompletableFuture.allOf((CompletableFuture[])DATABASE.values().stream().map(Map::values).flatMap(Collection::stream).distinct().map(it -> CompletableFuture.runAsync(() -> it.accept(payload), asyncExecutor)).toArray(CompletableFuture[]::new));
    }

    public static final CompletableFuture<Void> subscribe(BroadcastAddressData addressData, Executor asyncExecutor) {
        String key = addressData.getAddress();
        String topic = addressData.getNewAddress();
        if (!DATABASE.containsKey(topic)) {
            DATABASE.put(topic, new HashMap());
        }
        DATABASE.get(topic).put(key, DATABASE.get(key).get(key));
        return END;
    }

    public static final void unsubscribe(BroadcastAddressData addressData) {
        try {
            String topic = addressData.getNewAddress();
            Map<String, Consumer<String>> map = DATABASE.get(topic);
            map.remove(addressData.getAddress());
            if (map.isEmpty()) {
                DATABASE.remove(topic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean isSubscribed(BroadcastAddressData addressData) {
        try {
            return DATABASE.get(addressData.getNewAddress()).containsKey(addressData.getAddress());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final void register(final String key, final Consumer<String> messageHandler) {
        DATABASE.put(key, (Map<String, Consumer<String>>)new HashMap<String, Consumer<String>>(){
            {
                this.put(key, messageHandler);
            }
        });
    }

    public static final void unregister(String key) {
        try {
            DATABASE.remove(key);
            for (String topic : new HashSet<String>(DATABASE.keySet())) {
                Map<String, Consumer<String>> map = DATABASE.get(topic);
                map.remove(key);
                if (!map.isEmpty()) continue;
                DATABASE.remove(topic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String register(BiConsumer<String, GeneratedCoreType> messageHandler) {
        if (messageHandler == null) {
            return null;
        }
        String key = "" + (double)System.currentTimeMillis() * Math.random() + messageHandler.toString();
        GLOBAL_HOOKS.put(key, messageHandler);
        return key;
    }

    private static final void callHooks(String type, GeneratedCoreType element, Executor asyncExecutor) {
        CompletableFuture.allOf((CompletableFuture[])GLOBAL_HOOKS.values().stream().map(it -> CompletableFuture.runAsync(() -> it.accept(type, element), asyncExecutor)).toArray(CompletableFuture[]::new));
    }
}

