/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.Core;
import com.metaring.framework.SysKB;
import com.metaring.framework.email.EmailContact;
import com.metaring.framework.email.EmailContentFromTemplate;
import com.metaring.framework.email.EmailController;
import com.metaring.framework.email.EmailMessage;
import com.metaring.framework.email.EmailMessageSeries;
import com.metaring.framework.email.EmailTemplateArgument;
import com.metaring.framework.email.EmailTemplateArgumentSeries;
import com.metaring.framework.email.EmailTypeEnumerator;
import com.metaring.framework.email.JavaMailController;
import com.metaring.framework.email.SingleEmail;
import com.metaring.framework.email.SingleEmailTemplate;
import com.metaring.framework.exception.ManagedException;
import com.metaring.framework.functionality.UnmanagedException;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.CryptoUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

class EmailHelper {
    private static final String CFG_CONTROLLER = "controller";
    private static final String CFG_TEMPLATES_FOLDER = "templatesFolder";
    private static final String EMAIL_TEMPLATES_MODULE_INFO_CLASS_NAME = "com.metaring.framework.email.EmailTemplatesModuleInfo";
    protected static final String TEMPLATE_TYPE_SUBJECT = "_subject";
    protected static final String TEMPLATE_TYPE_MESSAGE = "_message";
    private static final String TEMPLATES_EXTENSION = ".stg";
    protected static EmailContact DEFAULT_EMAIL_SENDER;
    protected static final Map<String, STGroup> EMAIL_TEMPLATES;
    private static boolean MAIL_TEST;
    private static EmailController EMAIL_CONTROLLER;

    EmailHelper() {
    }

    public static void reinit() {
        if (EMAIL_CONTROLLER != null) {
            EMAIL_CONTROLLER.shutdown();
        }
        EMAIL_CONTROLLER = null;
        DEFAULT_EMAIL_SENDER = null;
        EMAIL_TEMPLATES.clear();
        MAIL_TEST = false;
        EmailHelper.setParameters();
    }

    private static void setParameters() {
        SysKB sysKB = Core.SYSKB;
        if (!sysKB.hasProperty("email").booleanValue()) {
            return;
        }
        DataRepresentation email = sysKB.get("email");
        EmailHelper.loadEmailTemplates();
        MAIL_TEST = false;
        try {
            MAIL_TEST = email.getTruth("test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!email.hasProperty("sender").booleanValue()) {
            return;
        }
        DEFAULT_EMAIL_SENDER = (EmailContact)email.get("sender", EmailContact.class);
        EmailHelper.initController(sysKB);
    }

    private static void initController(SysKB sysKB) {
        if (!sysKB.hasProperty("email").booleanValue()) {
            return;
        }
        DataRepresentation emailConfiguration = sysKB.get("email");
        String className = JavaMailController.class.getName();
        if (emailConfiguration.hasProperty(CFG_CONTROLLER).booleanValue()) {
            className = emailConfiguration.getText(CFG_CONTROLLER);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("An error occurred while creating class " + className, e);
        }
        try {
            EMAIL_CONTROLLER = (EmailController)clazz.newInstance();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new IllegalArgumentException("An error occurred while trying to access to init " + className, e);
        }
        if (EMAIL_CONTROLLER != null) {
            EMAIL_CONTROLLER.reinit(sysKB);
        }
    }

    private static final void loadEmailTemplates() {
        Class<?> templatesModuleClass = null;
        try {
            templatesModuleClass = Class.forName(EMAIL_TEMPLATES_MODULE_INFO_CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (templatesModuleClass == null) {
            return;
        }
        try {
            File templatesFolder = new File(Core.SYSKB.get("email").getText(CFG_TEMPLATES_FOLDER));
            File[] templates = templatesFolder.listFiles((path, name) -> name.toLowerCase().endsWith(TEMPLATES_EXTENSION));
            String charset = CryptoUtil.CHARSET_UTF_8.toString();
            for (File template : templates) {
                String key = template.getName();
                key = key.substring(0, key.lastIndexOf(46));
                EMAIL_TEMPLATES.put(key, (STGroup)new STGroupFile(template.getAbsolutePath(), charset));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static EmailContentFromTemplate getEmailContentFromTemplate(SingleEmailTemplate singleEmailTemplate) {
        STGroup templateGroup = EMAIL_TEMPLATES.get(singleEmailTemplate.getLanguage().getTextualValue());
        String subject = EmailHelper.getFilledByTemplate(templateGroup, singleEmailTemplate, TEMPLATE_TYPE_SUBJECT);
        String message = EmailHelper.getFilledByTemplate(templateGroup, singleEmailTemplate, TEMPLATE_TYPE_MESSAGE);
        EmailContentFromTemplate mailContentFromTemplate = EmailContentFromTemplate.create(subject, message, singleEmailTemplate.getLanguage());
        return mailContentFromTemplate;
    }

    public static String getFilledByTemplate(STGroup emailTemplateGroup, SingleEmailTemplate singleEmailTemplate, String emailTemplateType) {
        ST template = EmailHelper.getTemplateByName(emailTemplateGroup, singleEmailTemplate.getTemplateName(), emailTemplateType);
        return EmailHelper.getFilledByTemplate(emailTemplateGroup, template, singleEmailTemplate.getArguments());
    }

    public static String getFilledByTemplate(STGroup emailTemplateGroup, ST template, EmailTemplateArgumentSeries emailTemplateArgumentSeries) {
        String filledTemplateAsString;
        String filledTemplate = filledTemplateAsString = EmailHelper.getFilledTemplateAsString(template, emailTemplateArgumentSeries);
        return filledTemplate;
    }

    public static String getFilledTemplateAsString(ST template, EmailTemplateArgumentSeries emailTemplateArgumentSeries) {
        if (emailTemplateArgumentSeries != null && emailTemplateArgumentSeries.size() > 0) {
            for (EmailTemplateArgument mailTemplateArgument : emailTemplateArgumentSeries) {
                try {
                    DataRepresentation value = mailTemplateArgument.getValue();
                    String names = new StringJoiner(".").add(mailTemplateArgument.getName()).add(new StringJoiner(",", "{", "}").add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)value.getProperties())).toString()).toString();
                    Object[] values = value.getProperties().stream().map(current -> value.getText(current)).toArray();
                    template.addAggr(names, values);
                }
                catch (Exception exception) {}
            }
        }
        String filledTemplateAsString = template.render();
        return filledTemplateAsString;
    }

    public static ST getTemplateByName(STGroup emailTemplateGroup, String emailTemplate, String emailTemplateType) {
        String completeEmailTemplateName = emailTemplate + emailTemplateType;
        completeEmailTemplateName = completeEmailTemplateName.toLowerCase();
        return emailTemplateGroup.getInstanceOf(completeEmailTemplateName);
    }

    public static void send(EmailMessage emailMessage) throws ManagedException, UnmanagedException {
        EmailHelper.send(EmailMessageSeries.create(emailMessage));
    }

    public static void sendSingleEmail(SingleEmail singleEmail) throws ManagedException, UnmanagedException {
        EmailContentFromTemplate mailContentFromTemplate = EmailHelper.getEmailContentFromTemplate(singleEmail.getTemplate());
        EmailMessage emailMessage = EmailMessage.create(DEFAULT_EMAIL_SENDER, singleEmail.getTos(), singleEmail.getCcs(), singleEmail.getBccs(), mailContentFromTemplate.getSubject(), EmailTypeEnumerator.HTML, mailContentFromTemplate.getMessage());
        EmailHelper.send(emailMessage);
    }

    public static void send(EmailMessageSeries emailMessageSeries) throws ManagedException, UnmanagedException {
        if (MAIL_TEST) {
            System.out.println(emailMessageSeries.toJson());
        }
        EMAIL_CONTROLLER.send(emailMessageSeries);
    }

    static {
        EMAIL_TEMPLATES = new HashMap<String, STGroup>();
        EmailHelper.reinit();
    }
}

