/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.Email;

public class EmailContact
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.email.emailContact";
    private String name;
    private String surname;
    private Email mail;

    private EmailContact(String name, String surname, Email mail) {
        this.name = name;
        this.surname = surname;
        this.mail = mail;
    }

    public String getName() {
        return this.name;
    }

    public String getSurname() {
        return this.surname;
    }

    public Email getMail() {
        return this.mail;
    }

    public static EmailContact create(String name, String surname, Email mail) {
        return new EmailContact(name, surname, mail);
    }

    public static EmailContact fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String name = null;
        if (dataRepresentation.hasProperty("name").booleanValue()) {
            try {
                name = dataRepresentation.getText("name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String surname = null;
        if (dataRepresentation.hasProperty("surname").booleanValue()) {
            try {
                surname = dataRepresentation.getText("surname");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Email mail = null;
        if (dataRepresentation.hasProperty("mail").booleanValue()) {
            try {
                mail = dataRepresentation.getEmail("mail");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContact emailContact = EmailContact.create(name, surname, mail);
        return emailContact;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.name != null) {
            dataRepresentation.add("name", this.name);
        }
        if (this.surname != null) {
            dataRepresentation.add("surname", this.surname);
        }
        if (this.mail != null) {
            dataRepresentation.add("mail", this.mail);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

