/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.email.EmailContact;
import com.metaring.framework.email.EmailContactSeries;
import com.metaring.framework.email.EmailTypeEnumerator;
import com.metaring.framework.type.DataRepresentation;

public class EmailMessage
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.email.emailMessage";
    private EmailContact from;
    private EmailContactSeries tos;
    private EmailContactSeries ccs;
    private EmailContactSeries bccs;
    private String subject;
    private EmailTypeEnumerator type;
    private String message;

    private EmailMessage(EmailContact from, EmailContactSeries tos, EmailContactSeries ccs, EmailContactSeries bccs, String subject, EmailTypeEnumerator type, String message) {
        this.from = from;
        this.tos = tos;
        this.ccs = ccs;
        this.bccs = bccs;
        this.subject = subject;
        this.type = type;
        this.message = message;
    }

    public EmailContact getFrom() {
        return this.from;
    }

    public EmailContactSeries getTos() {
        return this.tos;
    }

    public EmailContactSeries getCcs() {
        return this.ccs;
    }

    public EmailContactSeries getBccs() {
        return this.bccs;
    }

    public String getSubject() {
        return this.subject;
    }

    public EmailTypeEnumerator getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static EmailMessage create(EmailContact from, EmailContactSeries tos, EmailContactSeries ccs, EmailContactSeries bccs, String subject, EmailTypeEnumerator type, String message) {
        return new EmailMessage(from, tos, ccs, bccs, subject, type, message);
    }

    public static EmailMessage fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        EmailContact from = null;
        if (dataRepresentation.hasProperty("from").booleanValue()) {
            try {
                from = (EmailContact)dataRepresentation.get("from", EmailContact.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries tos = null;
        if (dataRepresentation.hasProperty("tos").booleanValue()) {
            try {
                tos = (EmailContactSeries)dataRepresentation.get("tos", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries ccs = null;
        if (dataRepresentation.hasProperty("ccs").booleanValue()) {
            try {
                ccs = (EmailContactSeries)dataRepresentation.get("ccs", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries bccs = null;
        if (dataRepresentation.hasProperty("bccs").booleanValue()) {
            try {
                bccs = (EmailContactSeries)dataRepresentation.get("bccs", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String subject = null;
        if (dataRepresentation.hasProperty("subject").booleanValue()) {
            try {
                subject = dataRepresentation.getText("subject");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailTypeEnumerator type = null;
        if (dataRepresentation.hasProperty("type").booleanValue()) {
            try {
                type = (EmailTypeEnumerator)dataRepresentation.get("type", EmailTypeEnumerator.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String message = null;
        if (dataRepresentation.hasProperty("message").booleanValue()) {
            try {
                message = dataRepresentation.getText("message");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailMessage emailMessage = EmailMessage.create(from, tos, ccs, bccs, subject, type, message);
        return emailMessage;
    }

    public static EmailMessage fromObject(Object object) {
        if (object == null) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromObject(object);
        EmailContact from = null;
        if (dataRepresentation.hasProperty("from").booleanValue()) {
            try {
                from = (EmailContact)dataRepresentation.get("from", EmailContact.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries tos = null;
        if (dataRepresentation.hasProperty("tos").booleanValue()) {
            try {
                tos = (EmailContactSeries)dataRepresentation.get("tos", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries ccs = null;
        if (dataRepresentation.hasProperty("ccs").booleanValue()) {
            try {
                ccs = (EmailContactSeries)dataRepresentation.get("ccs", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContactSeries bccs = null;
        if (dataRepresentation.hasProperty("bccs").booleanValue()) {
            try {
                bccs = (EmailContactSeries)dataRepresentation.get("bccs", EmailContactSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String subject = null;
        if (dataRepresentation.hasProperty("subject").booleanValue()) {
            try {
                subject = dataRepresentation.getText("subject");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailTypeEnumerator type = null;
        if (dataRepresentation.hasProperty("type").booleanValue()) {
            try {
                type = (EmailTypeEnumerator)dataRepresentation.get("type", EmailTypeEnumerator.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String message = null;
        if (dataRepresentation.hasProperty("message").booleanValue()) {
            try {
                message = dataRepresentation.getText("message");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailMessage emailMessage = EmailMessage.create(from, tos, ccs, bccs, subject, type, message);
        return emailMessage;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.from != null) {
            dataRepresentation.add("from", (CoreType)this.from);
        }
        if (this.tos != null) {
            dataRepresentation.add("tos", (CoreType[])this.tos.toArray());
        }
        if (this.ccs != null) {
            dataRepresentation.add("ccs", (CoreType[])this.ccs.toArray());
        }
        if (this.bccs != null) {
            dataRepresentation.add("bccs", (CoreType[])this.bccs.toArray());
        }
        if (this.subject != null) {
            dataRepresentation.add("subject", this.subject);
        }
        if (this.type != null) {
            dataRepresentation.add("type", (CoreType)this.type);
        }
        if (this.message != null) {
            dataRepresentation.add("message", this.message);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

