/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.SysKB;
import com.metaring.framework.functionality.AbstractFunctionality;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityCreationException;
import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.functionality.FunctionalityNotFoundException;
import com.metaring.framework.util.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class FunctionalitiesProvider {
    private static final Map<String, Class<? extends Functionality>> CACHE = new HashMap<String, Class<? extends Functionality>>();
    private static final Map<String, AbstractFunctionality> INJECTIONS = new HashMap<String, AbstractFunctionality>();
    private static final Map<String, AbstractFunctionality> CLASSES_DICTIONARY = new HashMap<String, AbstractFunctionality>();

    public static final AbstractFunctionality getFunctionality(FunctionalityInfo functionalityInfo, Class<? extends Functionality> functionalityClass, SysKB sysKB) throws FunctionalityCreationException {
        if (!INJECTIONS.containsKey(functionalityInfo.getFunctionalityFullyQualifiedName())) {
            return FunctionalitiesProvider.createFunctionality(functionalityInfo, functionalityClass, sysKB);
        }
        return INJECTIONS.get(functionalityInfo.getFunctionalityFullyQualifiedName());
    }

    public static final AbstractFunctionality getFunctionalityByClassName(String className) {
        return CLASSES_DICTIONARY.get(className);
    }

    private static final AbstractFunctionality createFunctionality(FunctionalityInfo functionalityInfo, Class<? extends Functionality> functionalityClass, SysKB sysKB) throws FunctionalityCreationException {
        try {
            functionalityClass = FunctionalitiesProvider.load(functionalityInfo.getFunctionalityFullyQualifiedName(), functionalityClass);
            Method createMethod = functionalityClass.getDeclaredMethod("create", SysKB.class);
            createMethod.setAccessible(true);
            AbstractFunctionality functionality = (AbstractFunctionality)createMethod.invoke(null, sysKB);
            INJECTIONS.put(functionalityInfo.getFunctionalityFullyQualifiedName(), functionality);
            CLASSES_DICTIONARY.put(functionality.getClass().getName(), functionality);
            return functionality;
        }
        catch (Exception e) {
            throw new FunctionalityCreationException(functionalityInfo.getFunctionalityFullyQualifiedName(), e);
        }
    }

    private static final Class<? extends Functionality> load(String functionalityName, Class<? extends Functionality> functionalityClass) throws FunctionalityNotFoundException {
        if (!CACHE.containsKey(functionalityName)) {
            if (functionalityClass == null) {
                String className = functionalityName.substring(0, functionalityName.lastIndexOf(".") + 1);
                className = className + StringUtil.firstLetterToUpperCase((String)functionalityName.substring(functionalityName.lastIndexOf(".") + 1));
                className = className + "Functionality";
                try {
                    functionalityClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new FunctionalityNotFoundException(functionalityName, e);
                }
            }
            CACHE.put(functionalityName, functionalityClass);
        }
        return functionalityClass != null ? functionalityClass : CACHE.get(functionalityName);
    }
}

