/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;

public class FunctionalityInfo {
    private String functionalityFullyQualifiedName;
    private Boolean internal;
    private Boolean reserved;
    private Boolean restricted;
    private String inputFullyQualifiedName;
    private String outputFullyQualifiedName;

    private FunctionalityInfo(String functionalityFullyQualifiedName, Boolean internal, Boolean reserved, Boolean restricted, String inputFullyQualifiedName, String outputFullyQualifiedName) {
        this.functionalityFullyQualifiedName = functionalityFullyQualifiedName;
        this.internal = internal;
        this.reserved = reserved;
        this.restricted = restricted;
        this.inputFullyQualifiedName = inputFullyQualifiedName;
        this.outputFullyQualifiedName = outputFullyQualifiedName;
    }

    public String getFunctionalityFullyQualifiedName() {
        return this.functionalityFullyQualifiedName;
    }

    public Boolean isInternal() {
        return this.internal;
    }

    public Boolean isReserved() {
        return this.reserved;
    }

    public Boolean isRestricted() {
        return this.restricted;
    }

    public String getInputFullyQualifiedName() {
        return this.inputFullyQualifiedName;
    }

    public String getOutputFullyQualifiedName() {
        return this.outputFullyQualifiedName;
    }

    public static FunctionalityInfo create(String functionalityFullyQualifiedName, Boolean internal, Boolean reserved, Boolean restricted, String inputFullyQualifiedName, String outputFullyQualifiedName) {
        return new FunctionalityInfo(functionalityFullyQualifiedName, internal, reserved, restricted, inputFullyQualifiedName, outputFullyQualifiedName);
    }

    public static FunctionalityInfo fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String functionalityFullyQualifiedName = null;
        if (dataRepresentation.hasProperty("functionalityFullyQualifiedName").booleanValue()) {
            try {
                functionalityFullyQualifiedName = dataRepresentation.getText("functionalityFullyQualifiedName");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Boolean internal = null;
        if (dataRepresentation.hasProperty("internal").booleanValue()) {
            try {
                internal = dataRepresentation.getTruth("internal");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Boolean reserved = null;
        if (dataRepresentation.hasProperty("reserved").booleanValue()) {
            try {
                reserved = dataRepresentation.getTruth("reserved");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Boolean restricted = null;
        if (dataRepresentation.hasProperty("restricted").booleanValue()) {
            try {
                restricted = dataRepresentation.getTruth("restricted");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String inputFullyQualifiedName = null;
        if (dataRepresentation.hasProperty("inputFullyQualifiedName").booleanValue()) {
            try {
                inputFullyQualifiedName = dataRepresentation.getText("inputFullyQualifiedName");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String outputFullyQualifiedName = null;
        if (dataRepresentation.hasProperty("outputFullyQualifiedName").booleanValue()) {
            try {
                outputFullyQualifiedName = dataRepresentation.getText("outputFullyQualifiedName");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FunctionalityInfo functionalityInfo = FunctionalityInfo.create(functionalityFullyQualifiedName, internal, reserved, restricted, inputFullyQualifiedName, outputFullyQualifiedName);
        return functionalityInfo;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.functionalityFullyQualifiedName != null) {
            dataRepresentation.add("functionalityFullyQualifiedName", this.functionalityFullyQualifiedName);
        }
        if (this.internal != null) {
            dataRepresentation.add("internal", this.internal);
        }
        if (this.reserved != null) {
            dataRepresentation.add("reserved", this.reserved);
        }
        if (this.restricted != null) {
            dataRepresentation.add("restricted", this.restricted);
        }
        if (this.inputFullyQualifiedName != null) {
            dataRepresentation.add("inputFullyQualifiedName", this.inputFullyQualifiedName);
        }
        if (this.outputFullyQualifiedName != null) {
            dataRepresentation.add("outputFullyQualifiedName", this.outputFullyQualifiedName);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

