/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.functionality.FunctionalityNotFoundException;
import com.metaring.framework.util.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class FunctionalitiesInfoProvider {
    private static final Map<String, FunctionalityInfo> functionalitiesInfo = new HashMap<String, FunctionalityInfo>();

    public static FunctionalityInfo get(String functionalityFullyQualifiedName) throws FunctionalityNotFoundException {
        FunctionalityInfo functionality;
        String functionalityName = functionalityFullyQualifiedName;
        if (!functionalitiesInfo.containsKey(functionalityName)) {
            FunctionalitiesInfoProvider.retrieveFunctionality(functionalityName);
        }
        if ((functionality = functionalitiesInfo.get(functionalityName)) == null) {
            throw new FunctionalityNotFoundException(functionalityFullyQualifiedName);
        }
        return functionality;
    }

    private static void retrieveFunctionality(String functionalityName) {
        try {
            Class<?> managerClassName = FunctionalitiesInfoProvider.getManagerClass(functionalityName);
            String functionalityFieldName = functionalityName.substring(functionalityName.lastIndexOf(".") + 1);
            functionalityFieldName = StringUtil.toStaticFieldName((String)functionalityFieldName);
            Field functionalityField = managerClassName.getDeclaredField(functionalityFieldName);
            FunctionalityInfo functionalityInfo = (FunctionalityInfo)functionalityField.get(null);
            functionalitiesInfo.put(functionalityName, functionalityInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Class<?> getManagerClass(String call) {
        String managerClassName = call.substring(0, call.lastIndexOf("."));
        String managerName = StringUtil.firstLetterToUpperCase((String)managerClassName.substring(managerClassName.lastIndexOf(".") + 1));
        managerClassName = managerClassName + "." + managerName + "FunctionalitiesManager";
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(managerClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return managerClass;
    }
}

