/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.functionality.AbstractFunctionality;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityContextData;
import com.metaring.framework.functionality.FunctionalityControllerManager;
import com.metaring.framework.functionality.FunctionalityExecutionError;
import com.metaring.framework.functionality.FunctionalityExecutionWarningData;
import com.metaring.framework.functionality.FunctionalityExecutionWarningDataSeries;
import com.metaring.framework.functionality.FunctionalityStack;
import com.metaring.framework.functionality.FunctionalityStackElementSeries;
import com.metaring.framework.functionality.FunctionalityTransactionController;
import com.metaring.framework.functionality.FunctionalityTransactionControllerManager;
import com.metaring.framework.functionality.UnmanagedException;
import com.metaring.framework.util.StringUtil;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;

public class FunctionalityContext {
    private static final CompletableFuture<Void> END = CompletableFuture.completedFuture(null);
    protected LinkedList<FunctionalityExecutionWarningData> warnings = new LinkedList();
    private FunctionalityStack stack;
    private FunctionalityContextData data = new FunctionalityContextData();
    private FunctionalityTransactionController functionalityTransactionController;
    protected FunctionalityExecutionError executionError;

    public FunctionalityContext() {
        this.stack = new FunctionalityStack();
        FunctionalityTransactionControllerManager.createInstance().thenAcceptAsync(result -> {
            if (result == null) {
                return;
            }
            this.functionalityTransactionController = result;
            this.functionalityTransactionController.initTransaction(FunctionalityControllerManager.INSTANCE);
        }, FunctionalityControllerManager.INSTANCE);
    }

    public final FunctionalityStack getStack() {
        return this.stack;
    }

    public final FunctionalityContextData getData() {
        return this.data;
    }

    public final void purge() throws UnmanagedException {
        this.stack.purge();
        this.stack = null;
        this.data.purge();
        this.data = null;
        this.warnings.clear();
        this.warnings = null;
        this.executionError = null;
        if (this.functionalityTransactionController != null) {
            this.functionalityTransactionController.close(FunctionalityControllerManager.INSTANCE);
        }
        this.functionalityTransactionController = null;
    }

    public final void addWarningMessage(String warning) {
        if (!StringUtil.isNullOrEmpty((String)warning)) {
            this.warnings.addLast(FunctionalityExecutionWarningData.create(((AbstractFunctionality)this.getStack().getLast()).getCurrentStep(), warning));
        }
    }

    public final FunctionalityExecutionWarningDataSeries getWarnings() {
        if (this.warnings.isEmpty()) {
            return null;
        }
        return FunctionalityExecutionWarningDataSeries.create(this.warnings.toArray(new FunctionalityExecutionWarningData[this.warnings.size()]));
    }

    public final FunctionalityStackElementSeries getStackElementSeries() {
        return this.stack.toStackElementSeries();
    }

    public final FunctionalityStackElementSeries getStackElementSeriesTillNow(Functionality functionality) {
        return this.stack.toStackElementSeriesTillNow(functionality);
    }

    public final FunctionalityTransactionController getTransactionController() {
        return this.functionalityTransactionController;
    }

    public final CompletableFuture<Void> commitTransaction() {
        if (this.functionalityTransactionController != null && this.functionalityTransactionController.isInTransaction()) {
            return this.functionalityTransactionController.commitTransaction(FunctionalityControllerManager.INSTANCE);
        }
        return END;
    }

    public final CompletableFuture<Void> rollbackTransaction() {
        if (this.functionalityTransactionController != null && this.functionalityTransactionController.isInTransaction()) {
            return this.functionalityTransactionController.rollbackTransaction(FunctionalityControllerManager.INSTANCE);
        }
        return END;
    }
}

