/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.factory.DataRepresentationFactory;
import java.util.HashMap;

public class FunctionalityContextData
extends HashMap<String, Object> {
    private static final long serialVersionUID = 3777454499159654269L;

    @Override
    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    public void putSafely(String key, Object value) {
        String keyString = key;
        if (super.containsKey(keyString)) {
            throw new RuntimeException("Data " + keyString + " already exists in context and has value: " + super.get(keyString).toString());
        }
        super.put(keyString, value);
    }

    public Object remove(String key) {
        return super.remove(key);
    }

    public Object removeSafely(String key) {
        String keyString = key;
        if (!super.containsKey(keyString)) {
            throw new RuntimeException("Context does not contains data with key " + keyString);
        }
        return super.remove(keyString);
    }

    public Object get(String key) {
        return super.get(key);
    }

    public Boolean exists(String key) {
        return super.containsKey(key);
    }

    public void purge() {
        super.clear();
    }

    public final DataRepresentation toDataRepresentation() {
        DataRepresentationFactory dataRepresentationFactory = Tools.FACTORY_DATA_REPRESENTATION;
        DataRepresentation dataRep = dataRepresentationFactory.create();
        for (String key : this.keySet()) {
            Object value = this.get(key);
            try {
                dataRep.add(key, dataRepresentationFactory.fromObject(value));
            }
            catch (Exception e) {
                dataRep.add(key, dataRepresentationFactory.fromJson(value == null ? "null" : value.toString()));
            }
        }
        return dataRep;
    }
}

