/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.functionality.FunctionalityControllerManager;
import com.metaring.framework.functionality.SafeRunnable;
import com.metaring.framework.functionality.SafeSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BlockingExecutor {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static final <T> CompletableFuture<T> retrieveAsync(SafeSupplier<T> supplier) {
        CompletableFuture completableFuture = new CompletableFuture();
        EXECUTOR_SERVICE.execute(() -> {
            Object[] t = new Object[1];
            Throwable[] throwable = new Throwable[1];
            try {
                t[0] = supplier.get();
            }
            catch (Exception e) {
                throwable[0] = e;
            }
            CompletableFuture.runAsync(() -> {
                if (throwable[0] != null) {
                    completableFuture.completeExceptionally(throwable[0]);
                    return;
                }
                completableFuture.complete(t[0]);
            }, FunctionalityControllerManager.INSTANCE);
        });
        return completableFuture;
    }

    public static final CompletableFuture<Void> executeAsync(SafeRunnable runnable) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        EXECUTOR_SERVICE.execute(() -> {
            Throwable[] throwable = new Throwable[1];
            try {
                runnable.run();
            }
            catch (Exception e) {
                throwable[0] = e;
            }
            CompletableFuture.runAsync(() -> {
                if (throwable[0] != null) {
                    completableFuture.completeExceptionally(throwable[0]);
                    return;
                }
                completableFuture.complete(null);
            }, FunctionalityControllerManager.INSTANCE);
        });
        return completableFuture;
    }
}

