/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.Core;
import com.metaring.framework.SysKB;
import com.metaring.framework.functionality.FunctionalityControllerManager;
import com.metaring.framework.functionality.FunctionalityTransactionController;
import com.metaring.framework.type.DataRepresentation;
import java.util.concurrent.CompletableFuture;

public class FunctionalityTransactionControllerManager {
    private static final String CFG_PERSISTENCE = "persistence";
    private static final String CFG_CONTROLLER = "controller";
    private static final Class<? extends FunctionalityTransactionController> INSTANCE;

    static final CompletableFuture<FunctionalityTransactionController> createInstance() {
        try {
            if (INSTANCE == null) {
                return CompletableFuture.completedFuture(null);
            }
            return INSTANCE.newInstance().init(Core.SYSKB, FunctionalityControllerManager.INSTANCE);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new IllegalArgumentException("An error occurred while trying to access to Functionality Transaction Controller init " + INSTANCE.getName(), e);
        }
    }

    static {
        SysKB sysKB = Core.SYSKB;
        if (sysKB == null) {
            INSTANCE = null;
        } else if (!sysKB.hasProperty(CFG_PERSISTENCE).booleanValue()) {
            INSTANCE = null;
        } else {
            DataRepresentation functionalityDataRepresentation = sysKB.get(CFG_PERSISTENCE);
            if (!functionalityDataRepresentation.hasProperty(CFG_CONTROLLER).booleanValue()) {
                INSTANCE = null;
            } else {
                String className = functionalityDataRepresentation.getText(CFG_CONTROLLER);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("An error occurred while creating Functionality Transaction Controller class " + className, e);
                }
                INSTANCE = clazz;
            }
        }
    }
}

