/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.EmailImpl;
import com.metaring.framework.type.Email;
import com.metaring.framework.type.factory.EmailFactory;

final class EmailFactoryImpl
implements EmailFactory {
    EmailFactoryImpl() {
    }

    public Email create(String username, String domainName, String domainLocation) {
        if (username == null || username.trim().isEmpty()) {
            return null;
        }
        if (domainName == null || domainName.trim().isEmpty()) {
            return null;
        }
        if (domainLocation == null || domainLocation.trim().isEmpty()) {
            return null;
        }
        return new EmailImpl(username, domainName, domainLocation);
    }

    public Email create(String email) {
        if (email == null || email.trim().isEmpty()) {
            return null;
        }
        if (!email.contains("@")) {
            return null;
        }
        if (!email.contains(".")) {
            return null;
        }
        if (email.startsWith("\"")) {
            email = email.substring(1);
        }
        if (email.endsWith("\"")) {
            email = email.substring(0, email.length() - 1);
        }
        int atIndex = email.indexOf("@");
        int dotIndex = email.indexOf(".");
        while (dotIndex <= atIndex) {
            dotIndex = email.indexOf(".", dotIndex + 1);
        }
        String username = email.substring(0, atIndex);
        String domainName = email.substring(atIndex + 1, dotIndex);
        String domainLocation = email.substring(dotIndex + 1);
        return new EmailImpl(username, domainName, domainLocation);
    }

    public Email fromJson(String json) {
        return this.create(json);
    }
}

